/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.command;

import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.ICommandListener;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.command.ServerCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftChatMessage;

public class CraftBlockCommandSender
extends ServerCommandSender
implements BlockCommandSender {
    private final ICommandListener block;

    public CraftBlockCommandSender(ICommandListener commandBlockListenerAbstract) {
        this.block = commandBlockListenerAbstract;
    }

    @Override
    public Block getBlock() {
        return this.block.getWorld().getWorld().getBlockAt(this.block.getChunkCoordinates().getX(), this.block.getChunkCoordinates().getY(), this.block.getChunkCoordinates().getZ());
    }

    @Override
    public void sendMessage(String message) {
        IChatBaseComponent[] iChatBaseComponentArray = CraftChatMessage.fromString(message);
        int n = iChatBaseComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IChatBaseComponent component = iChatBaseComponentArray[n2];
            this.block.sendMessage(component);
            ++n2;
        }
    }

    @Override
    public void sendMessage(String[] messages) {
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            this.sendMessage(message);
            ++n2;
        }
    }

    @Override
    public String getName() {
        return this.block.getName();
    }

    @Override
    public boolean isOp() {
        return true;
    }

    @Override
    public void setOp(boolean value) {
        throw new UnsupportedOperationException("Cannot change operator status of a block");
    }

    public ICommandListener getTileEntity() {
        return this.block;
    }
}

