/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.v1_12_R1.DamageSource;
import net.minecraft.server.v1_12_R1.EntityAmbient;
import net.minecraft.server.v1_12_R1.EntityAnimal;
import net.minecraft.server.v1_12_R1.EntityAreaEffectCloud;
import net.minecraft.server.v1_12_R1.EntityArmorStand;
import net.minecraft.server.v1_12_R1.EntityArrow;
import net.minecraft.server.v1_12_R1.EntityBat;
import net.minecraft.server.v1_12_R1.EntityBlaze;
import net.minecraft.server.v1_12_R1.EntityBoat;
import net.minecraft.server.v1_12_R1.EntityCaveSpider;
import net.minecraft.server.v1_12_R1.EntityChicken;
import net.minecraft.server.v1_12_R1.EntityComplexPart;
import net.minecraft.server.v1_12_R1.EntityCow;
import net.minecraft.server.v1_12_R1.EntityCreature;
import net.minecraft.server.v1_12_R1.EntityCreeper;
import net.minecraft.server.v1_12_R1.EntityDragonFireball;
import net.minecraft.server.v1_12_R1.EntityEgg;
import net.minecraft.server.v1_12_R1.EntityEnderCrystal;
import net.minecraft.server.v1_12_R1.EntityEnderDragon;
import net.minecraft.server.v1_12_R1.EntityEnderPearl;
import net.minecraft.server.v1_12_R1.EntityEnderSignal;
import net.minecraft.server.v1_12_R1.EntityEnderman;
import net.minecraft.server.v1_12_R1.EntityEndermite;
import net.minecraft.server.v1_12_R1.EntityEvoker;
import net.minecraft.server.v1_12_R1.EntityEvokerFangs;
import net.minecraft.server.v1_12_R1.EntityExperienceOrb;
import net.minecraft.server.v1_12_R1.EntityFallingBlock;
import net.minecraft.server.v1_12_R1.EntityFireball;
import net.minecraft.server.v1_12_R1.EntityFireworks;
import net.minecraft.server.v1_12_R1.EntityFishingHook;
import net.minecraft.server.v1_12_R1.EntityFlying;
import net.minecraft.server.v1_12_R1.EntityGhast;
import net.minecraft.server.v1_12_R1.EntityGiantZombie;
import net.minecraft.server.v1_12_R1.EntityGolem;
import net.minecraft.server.v1_12_R1.EntityGuardian;
import net.minecraft.server.v1_12_R1.EntityGuardianElder;
import net.minecraft.server.v1_12_R1.EntityHanging;
import net.minecraft.server.v1_12_R1.EntityHorse;
import net.minecraft.server.v1_12_R1.EntityHorseAbstract;
import net.minecraft.server.v1_12_R1.EntityHorseChestedAbstract;
import net.minecraft.server.v1_12_R1.EntityHorseDonkey;
import net.minecraft.server.v1_12_R1.EntityHorseMule;
import net.minecraft.server.v1_12_R1.EntityHorseSkeleton;
import net.minecraft.server.v1_12_R1.EntityHorseZombie;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityIllagerAbstract;
import net.minecraft.server.v1_12_R1.EntityIllagerIllusioner;
import net.minecraft.server.v1_12_R1.EntityIllagerWizard;
import net.minecraft.server.v1_12_R1.EntityIronGolem;
import net.minecraft.server.v1_12_R1.EntityItem;
import net.minecraft.server.v1_12_R1.EntityItemFrame;
import net.minecraft.server.v1_12_R1.EntityLargeFireball;
import net.minecraft.server.v1_12_R1.EntityLeash;
import net.minecraft.server.v1_12_R1.EntityLightning;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntityLlama;
import net.minecraft.server.v1_12_R1.EntityLlamaSpit;
import net.minecraft.server.v1_12_R1.EntityMagmaCube;
import net.minecraft.server.v1_12_R1.EntityMinecartAbstract;
import net.minecraft.server.v1_12_R1.EntityMinecartChest;
import net.minecraft.server.v1_12_R1.EntityMinecartCommandBlock;
import net.minecraft.server.v1_12_R1.EntityMinecartFurnace;
import net.minecraft.server.v1_12_R1.EntityMinecartHopper;
import net.minecraft.server.v1_12_R1.EntityMinecartMobSpawner;
import net.minecraft.server.v1_12_R1.EntityMinecartRideable;
import net.minecraft.server.v1_12_R1.EntityMinecartTNT;
import net.minecraft.server.v1_12_R1.EntityMonster;
import net.minecraft.server.v1_12_R1.EntityMushroomCow;
import net.minecraft.server.v1_12_R1.EntityOcelot;
import net.minecraft.server.v1_12_R1.EntityPainting;
import net.minecraft.server.v1_12_R1.EntityParrot;
import net.minecraft.server.v1_12_R1.EntityPig;
import net.minecraft.server.v1_12_R1.EntityPigZombie;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.EntityPolarBear;
import net.minecraft.server.v1_12_R1.EntityPotion;
import net.minecraft.server.v1_12_R1.EntityProjectile;
import net.minecraft.server.v1_12_R1.EntityRabbit;
import net.minecraft.server.v1_12_R1.EntitySheep;
import net.minecraft.server.v1_12_R1.EntityShulker;
import net.minecraft.server.v1_12_R1.EntityShulkerBullet;
import net.minecraft.server.v1_12_R1.EntitySilverfish;
import net.minecraft.server.v1_12_R1.EntitySkeletonAbstract;
import net.minecraft.server.v1_12_R1.EntitySkeletonStray;
import net.minecraft.server.v1_12_R1.EntitySkeletonWither;
import net.minecraft.server.v1_12_R1.EntitySlime;
import net.minecraft.server.v1_12_R1.EntitySmallFireball;
import net.minecraft.server.v1_12_R1.EntitySnowball;
import net.minecraft.server.v1_12_R1.EntitySnowman;
import net.minecraft.server.v1_12_R1.EntitySpectralArrow;
import net.minecraft.server.v1_12_R1.EntitySpider;
import net.minecraft.server.v1_12_R1.EntitySquid;
import net.minecraft.server.v1_12_R1.EntityTNTPrimed;
import net.minecraft.server.v1_12_R1.EntityTameableAnimal;
import net.minecraft.server.v1_12_R1.EntityThrownExpBottle;
import net.minecraft.server.v1_12_R1.EntityTippedArrow;
import net.minecraft.server.v1_12_R1.EntityVex;
import net.minecraft.server.v1_12_R1.EntityVillager;
import net.minecraft.server.v1_12_R1.EntityVindicator;
import net.minecraft.server.v1_12_R1.EntityWaterAnimal;
import net.minecraft.server.v1_12_R1.EntityWeather;
import net.minecraft.server.v1_12_R1.EntityWitch;
import net.minecraft.server.v1_12_R1.EntityWither;
import net.minecraft.server.v1_12_R1.EntityWitherSkull;
import net.minecraft.server.v1_12_R1.EntityWolf;
import net.minecraft.server.v1_12_R1.EntityZombie;
import net.minecraft.server.v1_12_R1.EntityZombieHusk;
import net.minecraft.server.v1_12_R1.EntityZombieVillager;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftAmbient;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftAreaEffectCloud;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftBat;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftBlaze;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftCow;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftDonkey;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftDragonFireball;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftElderGuardian;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEnderPearl;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEndermite;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEvoker;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEvokerFangs;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftFireball;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftFish;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftFlying;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftGiant;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftGuardian;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHorse;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHusk;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftIllager;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftIllusioner;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftIronGolem;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftItemFrame;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLargeFireball;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLeash;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLingeringPotion;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLlama;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLlamaSpit;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMagmaCube;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMinecartChest;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMinecartFurnace;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMinecartHopper;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMinecartMobSpawner;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMinecartRideable;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMinecartTNT;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMule;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftMushroomCow;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftOcelot;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPainting;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftParrot;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPig;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPigZombie;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPolarBear;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftRabbit;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSheep;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftShulkerBullet;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSilverfish;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSkeleton;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSkeletonHorse;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSlime;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSmallFireball;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSnowball;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSnowman;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSpectralArrow;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSpider;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSplashPotion;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftSquid;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftStray;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftThrownExpBottle;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftTippedArrow;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftVex;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftVillagerZombie;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftVindicator;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftWaterMob;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftWeather;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftWitch;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftWither;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftWitherSkeleton;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftZombieHorse;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class CraftEntity
implements Entity {
    private static PermissibleBase perm;
    protected final CraftServer server;
    protected net.minecraft.server.v1_12_R1.Entity entity;
    private EntityDamageEvent lastDamageEvent;
    private final Entity.Spigot spigot = new Entity.Spigot(){

        @Override
        public boolean isInvulnerable() {
            return CraftEntity.this.getHandle().isInvulnerable(DamageSource.GENERIC);
        }

        @Override
        public void sendMessage(BaseComponent component) {
        }

        @Override
        public void sendMessage(BaseComponent ... components) {
        }
    };

    public CraftEntity(CraftServer server, net.minecraft.server.v1_12_R1.Entity entity) {
        this.server = server;
        this.entity = entity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CraftEntity getEntity(CraftServer server, net.minecraft.server.v1_12_R1.Entity entity) {
        if (entity instanceof EntityLiving) {
            if (entity instanceof EntityHuman) {
                if (!(entity instanceof EntityPlayer)) return new CraftHumanEntity(server, (EntityHuman)entity);
                return new CraftPlayer(server, (EntityPlayer)entity);
            }
            if (entity instanceof EntityWaterAnimal) {
                if (!(entity instanceof EntitySquid)) return new CraftWaterMob(server, (EntityWaterAnimal)entity);
                return new CraftSquid(server, (EntitySquid)entity);
            }
            if (entity instanceof EntityCreature) {
                if (entity instanceof EntityAnimal) {
                    if (entity instanceof EntityChicken) {
                        return new CraftChicken(server, (EntityChicken)entity);
                    }
                    if (entity instanceof EntityCow) {
                        if (!(entity instanceof EntityMushroomCow)) return new CraftCow(server, (EntityCow)entity);
                        return new CraftMushroomCow(server, (EntityMushroomCow)entity);
                    }
                    if (entity instanceof EntityPig) {
                        return new CraftPig(server, (EntityPig)entity);
                    }
                    if (entity instanceof EntityTameableAnimal) {
                        if (entity instanceof EntityWolf) {
                            return new CraftWolf(server, (EntityWolf)entity);
                        }
                        if (entity instanceof EntityOcelot) {
                            return new CraftOcelot(server, (EntityOcelot)entity);
                        }
                        if (!(entity instanceof EntityParrot)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                        return new CraftParrot(server, (EntityParrot)entity);
                    }
                    if (entity instanceof EntitySheep) {
                        return new CraftSheep(server, (EntitySheep)entity);
                    }
                    if (entity instanceof EntityHorseAbstract) {
                        if (entity instanceof EntityHorseChestedAbstract) {
                            if (entity instanceof EntityHorseDonkey) {
                                return new CraftDonkey(server, (EntityHorseDonkey)entity);
                            }
                            if (entity instanceof EntityHorseMule) {
                                return new CraftMule(server, (EntityHorseMule)entity);
                            }
                            if (!(entity instanceof EntityLlama)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                            return new CraftLlama(server, (EntityLlama)entity);
                        }
                        if (entity instanceof EntityHorse) {
                            return new CraftHorse(server, (EntityHorse)entity);
                        }
                        if (entity instanceof EntityHorseSkeleton) {
                            return new CraftSkeletonHorse(server, (EntityHorseSkeleton)entity);
                        }
                        if (!(entity instanceof EntityHorseZombie)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                        return new CraftZombieHorse(server, (EntityHorseZombie)entity);
                    }
                    if (entity instanceof EntityRabbit) {
                        return new CraftRabbit(server, (EntityRabbit)entity);
                    }
                    if (!(entity instanceof EntityPolarBear)) return new CraftAnimals(server, (EntityAnimal)entity);
                    return new CraftPolarBear(server, (EntityPolarBear)entity);
                }
                if (entity instanceof EntityMonster) {
                    if (entity instanceof EntityZombie) {
                        if (entity instanceof EntityPigZombie) {
                            return new CraftPigZombie(server, (EntityPigZombie)entity);
                        }
                        if (entity instanceof EntityZombieHusk) {
                            return new CraftHusk(server, (EntityZombieHusk)entity);
                        }
                        if (!(entity instanceof EntityZombieVillager)) return new CraftZombie(server, (EntityZombie)entity);
                        return new CraftVillagerZombie(server, (EntityZombieVillager)entity);
                    }
                    if (entity instanceof EntityCreeper) {
                        return new CraftCreeper(server, (EntityCreeper)entity);
                    }
                    if (entity instanceof EntityEnderman) {
                        return new CraftEnderman(server, (EntityEnderman)entity);
                    }
                    if (entity instanceof EntitySilverfish) {
                        return new CraftSilverfish(server, (EntitySilverfish)entity);
                    }
                    if (entity instanceof EntityGiantZombie) {
                        return new CraftGiant(server, (EntityGiantZombie)entity);
                    }
                    if (entity instanceof EntitySkeletonAbstract) {
                        if (entity instanceof EntitySkeletonStray) {
                            return new CraftStray(server, (EntitySkeletonStray)entity);
                        }
                        if (!(entity instanceof EntitySkeletonWither)) return new CraftSkeleton(server, (EntitySkeletonAbstract)entity);
                        return new CraftWitherSkeleton(server, (EntitySkeletonWither)entity);
                    }
                    if (entity instanceof EntityBlaze) {
                        return new CraftBlaze(server, (EntityBlaze)entity);
                    }
                    if (entity instanceof EntityWitch) {
                        return new CraftWitch(server, (EntityWitch)entity);
                    }
                    if (entity instanceof EntityWither) {
                        return new CraftWither(server, (EntityWither)entity);
                    }
                    if (entity instanceof EntitySpider) {
                        if (!(entity instanceof EntityCaveSpider)) return new CraftSpider(server, (EntitySpider)entity);
                        return new CraftCaveSpider(server, (EntityCaveSpider)entity);
                    }
                    if (entity instanceof EntityEndermite) {
                        return new CraftEndermite(server, (EntityEndermite)entity);
                    }
                    if (entity instanceof EntityGuardian) {
                        if (!(entity instanceof EntityGuardianElder)) return new CraftGuardian(server, (EntityGuardian)entity);
                        return new CraftElderGuardian(server, (EntityGuardianElder)entity);
                    }
                    if (entity instanceof EntityVex) {
                        return new CraftVex(server, (EntityVex)entity);
                    }
                    if (!(entity instanceof EntityIllagerAbstract)) return new CraftMonster(server, (EntityMonster)entity);
                    if (entity instanceof EntityIllagerWizard) {
                        if (entity instanceof EntityEvoker) {
                            return new CraftEvoker(server, (EntityEvoker)entity);
                        }
                        if (!(entity instanceof EntityIllagerIllusioner)) return new CraftSpellcaster(server, (EntityIllagerWizard)entity);
                        return new CraftIllusioner(server, (EntityIllagerIllusioner)entity);
                    }
                    if (!(entity instanceof EntityVindicator)) return new CraftIllager(server, (EntityIllagerAbstract)entity);
                    return new CraftVindicator(server, (EntityVindicator)entity);
                }
                if (entity instanceof EntityGolem) {
                    if (entity instanceof EntitySnowman) {
                        return new CraftSnowman(server, (EntitySnowman)entity);
                    }
                    if (entity instanceof EntityIronGolem) {
                        return new CraftIronGolem(server, (EntityIronGolem)entity);
                    }
                    if (!(entity instanceof EntityShulker)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                    return new CraftShulker(server, (EntityShulker)entity);
                }
                if (!(entity instanceof EntityVillager)) return new CraftCreature(server, (EntityCreature)entity);
                return new CraftVillager(server, (EntityVillager)entity);
            }
            if (entity instanceof EntitySlime) {
                if (!(entity instanceof EntityMagmaCube)) return new CraftSlime(server, (EntitySlime)entity);
                return new CraftMagmaCube(server, (EntityMagmaCube)entity);
            }
            if (entity instanceof EntityFlying) {
                if (!(entity instanceof EntityGhast)) return new CraftFlying(server, (EntityFlying)entity);
                return new CraftGhast(server, (EntityGhast)entity);
            }
            if (entity instanceof EntityEnderDragon) {
                return new CraftEnderDragon(server, (EntityEnderDragon)entity);
            }
            if (entity instanceof EntityAmbient) {
                if (!(entity instanceof EntityBat)) return new CraftAmbient(server, (EntityAmbient)entity);
                return new CraftBat(server, (EntityBat)entity);
            }
            if (!(entity instanceof EntityArmorStand)) return new CraftLivingEntity(server, (EntityLiving)entity);
            return new CraftArmorStand(server, (EntityArmorStand)entity);
        }
        if (entity instanceof EntityComplexPart) {
            EntityComplexPart part = (EntityComplexPart)entity;
            if (!(part.owner instanceof EntityEnderDragon)) return new CraftComplexPart(server, (EntityComplexPart)entity);
            return new CraftEnderDragonPart(server, (EntityComplexPart)entity);
        }
        if (entity instanceof EntityExperienceOrb) {
            return new CraftExperienceOrb(server, (EntityExperienceOrb)entity);
        }
        if (entity instanceof EntityTippedArrow) {
            if (!((EntityTippedArrow)entity).isTipped()) return new CraftArrow(server, (EntityArrow)entity);
            return new CraftTippedArrow(server, (EntityTippedArrow)entity);
        }
        if (entity instanceof EntitySpectralArrow) {
            return new CraftSpectralArrow(server, (EntitySpectralArrow)entity);
        }
        if (entity instanceof EntityArrow) {
            return new CraftArrow(server, (EntityArrow)entity);
        }
        if (entity instanceof EntityBoat) {
            return new CraftBoat(server, (EntityBoat)entity);
        }
        if (entity instanceof EntityProjectile) {
            if (entity instanceof EntityEgg) {
                return new CraftEgg(server, (EntityEgg)entity);
            }
            if (entity instanceof EntitySnowball) {
                return new CraftSnowball(server, (EntitySnowball)entity);
            }
            if (entity instanceof EntityPotion) {
                if (((EntityPotion)entity).isLingering()) return new CraftLingeringPotion(server, (EntityPotion)entity);
                return new CraftSplashPotion(server, (EntityPotion)entity);
            }
            if (entity instanceof EntityEnderPearl) {
                return new CraftEnderPearl(server, (EntityEnderPearl)entity);
            }
            if (!(entity instanceof EntityThrownExpBottle)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
            return new CraftThrownExpBottle(server, (EntityThrownExpBottle)entity);
        }
        if (entity instanceof EntityFallingBlock) {
            return new CraftFallingBlock(server, (EntityFallingBlock)entity);
        }
        if (entity instanceof EntityFireball) {
            if (entity instanceof EntitySmallFireball) {
                return new CraftSmallFireball(server, (EntitySmallFireball)entity);
            }
            if (entity instanceof EntityLargeFireball) {
                return new CraftLargeFireball(server, (EntityLargeFireball)entity);
            }
            if (entity instanceof EntityWitherSkull) {
                return new CraftWitherSkull(server, (EntityWitherSkull)entity);
            }
            if (!(entity instanceof EntityDragonFireball)) return new CraftFireball(server, (EntityFireball)entity);
            return new CraftDragonFireball(server, (EntityDragonFireball)entity);
        }
        if (entity instanceof EntityEnderSignal) {
            return new CraftEnderSignal(server, (EntityEnderSignal)entity);
        }
        if (entity instanceof EntityEnderCrystal) {
            return new CraftEnderCrystal(server, (EntityEnderCrystal)entity);
        }
        if (entity instanceof EntityFishingHook) {
            return new CraftFish(server, (EntityFishingHook)entity);
        }
        if (entity instanceof EntityItem) {
            return new CraftItem(server, (EntityItem)entity);
        }
        if (entity instanceof EntityWeather) {
            if (!(entity instanceof EntityLightning)) return new CraftWeather(server, (EntityWeather)entity);
            return new CraftLightningStrike(server, (EntityLightning)entity);
        }
        if (entity instanceof EntityMinecartAbstract) {
            if (entity instanceof EntityMinecartFurnace) {
                return new CraftMinecartFurnace(server, (EntityMinecartFurnace)entity);
            }
            if (entity instanceof EntityMinecartChest) {
                return new CraftMinecartChest(server, (EntityMinecartChest)entity);
            }
            if (entity instanceof EntityMinecartTNT) {
                return new CraftMinecartTNT(server, (EntityMinecartTNT)entity);
            }
            if (entity instanceof EntityMinecartHopper) {
                return new CraftMinecartHopper(server, (EntityMinecartHopper)entity);
            }
            if (entity instanceof EntityMinecartMobSpawner) {
                return new CraftMinecartMobSpawner(server, (EntityMinecartMobSpawner)entity);
            }
            if (entity instanceof EntityMinecartRideable) {
                return new CraftMinecartRideable(server, (EntityMinecartAbstract)((EntityMinecartRideable)entity));
            }
            if (!(entity instanceof EntityMinecartCommandBlock)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
            return new CraftMinecartCommand(server, (EntityMinecartCommandBlock)entity);
        }
        if (entity instanceof EntityHanging) {
            if (entity instanceof EntityPainting) {
                return new CraftPainting(server, (EntityPainting)entity);
            }
            if (entity instanceof EntityItemFrame) {
                return new CraftItemFrame(server, (EntityItemFrame)entity);
            }
            if (!(entity instanceof EntityLeash)) return new CraftHanging(server, (EntityHanging)entity);
            return new CraftLeash(server, (EntityLeash)entity);
        }
        if (entity instanceof EntityTNTPrimed) {
            return new CraftTNTPrimed(server, (EntityTNTPrimed)entity);
        }
        if (entity instanceof EntityFireworks) {
            return new CraftFirework(server, (EntityFireworks)entity);
        }
        if (entity instanceof EntityShulkerBullet) {
            return new CraftShulkerBullet(server, (EntityShulkerBullet)entity);
        }
        if (entity instanceof EntityAreaEffectCloud) {
            return new CraftAreaEffectCloud(server, (EntityAreaEffectCloud)entity);
        }
        if (entity instanceof EntityEvokerFangs) {
            return new CraftEvokerFangs(server, (EntityEvokerFangs)entity);
        }
        if (!(entity instanceof EntityLlamaSpit)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
        return new CraftLlamaSpit(server, (EntityLlamaSpit)entity);
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.entity.locX, this.entity.locY, this.entity.locZ, this.entity.getBukkitYaw(), this.entity.pitch);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.locX);
            loc.setY(this.entity.locY);
            loc.setZ(this.entity.locZ);
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.pitch);
        }
        return loc;
    }

    @Override
    public Vector getVelocity() {
        return new Vector(this.entity.motX, this.entity.motY, this.entity.motZ);
    }

    @Override
    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        velocity.checkFinite();
        this.entity.motX = velocity.getX();
        this.entity.motY = velocity.getY();
        this.entity.motZ = velocity.getZ();
        this.entity.velocityChanged = true;
    }

    @Override
    public double getHeight() {
        return this.getHandle().length;
    }

    @Override
    public double getWidth() {
        return this.getHandle().width;
    }

    @Override
    public boolean isOnGround() {
        if (this.entity instanceof EntityArrow) {
            return ((EntityArrow)this.entity).inGround;
        }
        return this.entity.onGround;
    }

    @Override
    public World getWorld() {
        return this.entity.world.getWorld();
    }

    @Override
    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        location.checkFinite();
        if (this.entity.isVehicle() || this.entity.dead) {
            return false;
        }
        this.entity.stopRiding();
        if (!location.getWorld().equals(this.getWorld())) {
            this.entity.teleportTo(location, cause.equals((Object)PlayerTeleportEvent.TeleportCause.NETHER_PORTAL));
            return true;
        }
        this.entity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.entity.setHeadRotation(location.getYaw());
        this.entity.world.entityJoinedWorld(this.entity, false);
        return true;
    }

    @Override
    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    @Override
    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    @Override
    public List<Entity> getNearbyEntities(double x, double y, double z) {
        List notchEntityList = this.entity.world.getEntities(this.entity, this.entity.getBoundingBox().grow(x, y, z), null);
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (net.minecraft.server.v1_12_R1.Entity e : notchEntityList) {
            bukkitEntityList.add(e.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    @Override
    public int getEntityId() {
        return this.entity.getId();
    }

    @Override
    public int getFireTicks() {
        return this.entity.fireTicks;
    }

    @Override
    public int getMaxFireTicks() {
        return this.entity.getMaxFireTicks();
    }

    @Override
    public void setFireTicks(int ticks) {
        this.entity.fireTicks = ticks;
    }

    @Override
    public void remove() {
        this.entity.die();
    }

    @Override
    public boolean isDead() {
        return !this.entity.isAlive();
    }

    @Override
    public boolean isValid() {
        return this.entity.isAlive() && this.entity.valid;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    @Override
    public Entity getPassenger() {
        return this.isEmpty() ? null : ((net.minecraft.server.v1_12_R1.Entity)this.getHandle().passengers.get(0)).getBukkitEntity();
    }

    @Override
    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().startRiding(this.getHandle());
        }
        return false;
    }

    @Override
    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform((List)this.getHandle().passengers, (Function)new Function<net.minecraft.server.v1_12_R1.Entity, Entity>(){

            public Entity apply(net.minecraft.server.v1_12_R1.Entity input) {
                return input.getBukkitEntity();
            }
        }));
    }

    @Override
    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"passenger == null");
        return ((CraftEntity)passenger).getHandle().a(this.getHandle(), true);
    }

    @Override
    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"passenger == null");
        ((CraftEntity)passenger).getHandle().stopRiding();
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !this.getHandle().isVehicle();
    }

    @Override
    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().ejectPassengers();
        return true;
    }

    @Override
    public float getFallDistance() {
        return this.getHandle().fallDistance;
    }

    @Override
    public void setFallDistance(float distance) {
        this.getHandle().fallDistance = distance;
    }

    @Override
    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    @Override
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    @Override
    public UUID getUniqueId() {
        return this.getHandle().getUniqueID();
    }

    @Override
    public int getTicksLived() {
        return this.getHandle().ticksLived;
    }

    @Override
    public void setTicksLived(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Age must be at least 1 tick");
        }
        this.getHandle().ticksLived = value;
    }

    public net.minecraft.server.v1_12_R1.Entity getHandle() {
        return this.entity;
    }

    @Override
    public void playEffect(EntityEffect type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        if (type.getApplicable().isInstance(this)) {
            this.getHandle().world.broadcastEntityEffect(this.getHandle(), type.getData());
        }
    }

    public void setHandle(net.minecraft.server.v1_12_R1.Entity entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getEntityId() == other.getEntityId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getEntityId();
        return hash;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean isInsideVehicle() {
        return this.getHandle().isPassenger();
    }

    @Override
    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().stopRiding();
        return true;
    }

    @Override
    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().bJ().getBukkitEntity();
    }

    @Override
    public void setCustomName(String name) {
        if (name == null) {
            name = "";
        }
        this.getHandle().setCustomName(name);
    }

    @Override
    public String getCustomName() {
        String name = this.getHandle().getCustomName();
        if (name == null || name.length() == 0) {
            return null;
        }
        return name;
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        this.getHandle().setCustomNameVisible(flag);
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.getHandle().getCustomNameVisible();
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public void sendMessage(String[] messages) {
    }

    @Override
    public String getName() {
        return this.getHandle().getName();
    }

    @Override
    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    @Override
    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    @Override
    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    @Override
    public void setGlowing(boolean flag) {
        this.getHandle().glowing = flag;
        net.minecraft.server.v1_12_R1.Entity e = this.getHandle();
        if (e.getFlag(6) != flag) {
            e.setFlag(6, flag);
        }
    }

    @Override
    public boolean isGlowing() {
        return this.getHandle().glowing;
    }

    @Override
    public void setInvulnerable(boolean flag) {
        this.getHandle().setInvulnerable(flag);
    }

    @Override
    public boolean isInvulnerable() {
        return this.getHandle().isInvulnerable(DamageSource.GENERIC);
    }

    @Override
    public boolean isSilent() {
        return this.getHandle().isSilent();
    }

    @Override
    public void setSilent(boolean flag) {
        this.getHandle().setSilent(flag);
    }

    @Override
    public boolean hasGravity() {
        return !this.getHandle().isNoGravity();
    }

    @Override
    public void setGravity(boolean gravity) {
        this.getHandle().setNoGravity(!gravity);
    }

    @Override
    public int getPortalCooldown() {
        return this.getHandle().portalCooldown;
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        this.getHandle().portalCooldown = cooldown;
    }

    @Override
    public Set<String> getScoreboardTags() {
        return this.getHandle().getScoreboardTags();
    }

    @Override
    public boolean addScoreboardTag(String tag) {
        return this.getHandle().addScoreboardTag(tag);
    }

    @Override
    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().removeScoreboardTag(tag);
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getHandle().getPushReaction().ordinal());
    }

    protected NBTTagCompound save() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setString("id", this.getHandle().getSaveID());
        this.getHandle().save(nbttagcompound);
        return nbttagcompound;
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                @Override
                public boolean isOp() {
                    return false;
                }

                @Override
                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    @Override
    public Entity.Spigot spigot() {
        return this.spigot;
    }
}

