/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import net.minecraft.server.v1_12_R1.EntityHorse;
import net.minecraft.server.v1_12_R1.EntityHorseAbstract;
import net.minecraft.server.v1_12_R1.IInventory;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryHorse;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.HorseInventory;

public class CraftHorse
extends CraftAbstractHorse
implements Horse {
    public CraftHorse(CraftServer server, EntityHorse entity) {
        super(server, (EntityHorseAbstract)entity);
    }

    public EntityHorse getHandle() {
        return (EntityHorse)super.getHandle();
    }

    @Override
    public Horse.Variant getVariant() {
        return Horse.Variant.HORSE;
    }

    @Override
    public Horse.Color getColor() {
        return Horse.Color.values()[this.getHandle().getVariant() & 0xFF];
    }

    @Override
    public void setColor(Horse.Color color) {
        Validate.notNull((Object)((Object)color), (String)"Color cannot be null");
        this.getHandle().setVariant(color.ordinal() & 0xFF | this.getStyle().ordinal() << 8);
    }

    @Override
    public Horse.Style getStyle() {
        return Horse.Style.values()[this.getHandle().getVariant() >>> 8];
    }

    @Override
    public void setStyle(Horse.Style style) {
        Validate.notNull((Object)((Object)style), (String)"Style cannot be null");
        this.getHandle().setVariant(this.getColor().ordinal() & 0xFF | style.ordinal() << 8);
    }

    @Override
    public boolean isCarryingChest() {
        return false;
    }

    @Override
    public void setCarryingChest(boolean chest) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public HorseInventory getInventory() {
        return new CraftInventoryHorse((IInventory)this.getHandle().inventoryChest);
    }

    @Override
    public String toString() {
        return "CraftHorse{variant=" + (Object)((Object)this.getVariant()) + ", owner=" + this.getOwner() + '}';
    }

    @Override
    public EntityType getType() {
        return EntityType.HORSE;
    }
}

