/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.server.v1_12_R1.EntityHorseChestedAbstract;
import net.minecraft.server.v1_12_R1.EntityLlama;
import net.minecraft.server.v1_12_R1.IInventory;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryLlama;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;

public class CraftLlama
extends CraftChestedHorse
implements Llama {
    public CraftLlama(CraftServer server, EntityLlama entity) {
        super(server, (EntityHorseChestedAbstract)entity);
    }

    public EntityLlama getHandle() {
        return (EntityLlama)super.getHandle();
    }

    @Override
    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().getVariant()];
    }

    @Override
    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().setVariant(color.ordinal());
    }

    @Override
    public LlamaInventory getInventory() {
        return new CraftInventoryLlama((IInventory)this.getHandle().inventoryChest);
    }

    @Override
    public int getStrength() {
        return this.getHandle().getStrength();
    }

    @Override
    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().setStrength(strength);
        this.getHandle().loadChest();
    }

    @Override
    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    @Override
    public String toString() {
        return "CraftLlama";
    }

    @Override
    public EntityType getType() {
        return EntityType.LLAMA;
    }
}

