/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityMinecartAbstract;
import net.minecraft.server.v1_12_R1.IBlockData;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftVehicle;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Minecart;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public abstract class CraftMinecart
extends CraftVehicle
implements Minecart {
    public CraftMinecart(CraftServer server, EntityMinecartAbstract entity) {
        super(server, (Entity)entity);
    }

    @Override
    public void setDamage(double damage) {
        this.getHandle().setDamage((float)damage);
    }

    @Override
    public double getDamage() {
        return this.getHandle().getDamage();
    }

    @Override
    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    @Override
    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    @Override
    public boolean isSlowWhenEmpty() {
        return this.getHandle().slowWhenEmpty;
    }

    @Override
    public void setSlowWhenEmpty(boolean slow) {
        this.getHandle().slowWhenEmpty = slow;
    }

    @Override
    public Vector getFlyingVelocityMod() {
        return this.getHandle().getFlyingVelocityMod();
    }

    @Override
    public void setFlyingVelocityMod(Vector flying) {
        this.getHandle().setFlyingVelocityMod(flying);
    }

    @Override
    public Vector getDerailedVelocityMod() {
        return this.getHandle().getDerailedVelocityMod();
    }

    @Override
    public void setDerailedVelocityMod(Vector derailed) {
        this.getHandle().setDerailedVelocityMod(derailed);
    }

    public EntityMinecartAbstract getHandle() {
        return (EntityMinecartAbstract)this.entity;
    }

    @Override
    public void setDisplayBlock(MaterialData material) {
        if (material != null) {
            IBlockData block = CraftMagicNumbers.getBlock(material.getItemTypeId()).fromLegacyData((int)material.getData());
            this.getHandle().setDisplayBlock(block);
        } else {
            this.getHandle().setDisplayBlock(Blocks.AIR.getBlockData());
            this.getHandle().a(false);
        }
    }

    @Override
    public MaterialData getDisplayBlock() {
        IBlockData blockData = this.getHandle().getDisplayBlock();
        return CraftMagicNumbers.getMaterial(blockData.getBlock()).getNewData((byte)blockData.getBlock().toLegacyData(blockData));
    }

    @Override
    public void setDisplayBlockOffset(int offset) {
        this.getHandle().setDisplayBlockOffset(offset);
    }

    @Override
    public int getDisplayBlockOffset() {
        return this.getHandle().getDisplayBlockOffset();
    }
}

