/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.entity;

import net.minecraft.server.v1_12_R1.EntityAnimal;
import net.minecraft.server.v1_12_R1.EntityRabbit;
import net.minecraft.server.v1_12_R1.PathfinderGoalSelector;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftAnimals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Rabbit;

public class CraftRabbit
extends CraftAnimals
implements Rabbit {
    public CraftRabbit(CraftServer server, EntityRabbit entity) {
        super(server, (EntityAnimal)entity);
    }

    public EntityRabbit getHandle() {
        return (EntityRabbit)this.entity;
    }

    @Override
    public String toString() {
        return "CraftRabbit{RabbitType=" + (Object)((Object)this.getRabbitType()) + "}";
    }

    @Override
    public EntityType getType() {
        return EntityType.RABBIT;
    }

    @Override
    public Rabbit.Type getRabbitType() {
        int type = this.getHandle().getRabbitType();
        return CraftMagicMapping.fromMagic(type);
    }

    @Override
    public void setRabbitType(Rabbit.Type type) {
        EntityRabbit entity = this.getHandle();
        if (this.getRabbitType() == Rabbit.Type.THE_KILLER_BUNNY) {
            WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
            entity.goalSelector = new PathfinderGoalSelector(world != null && world.methodProfiler != null ? world.methodProfiler : null);
            entity.targetSelector = new PathfinderGoalSelector(world != null && world.methodProfiler != null ? world.methodProfiler : null);
            entity.initializePathFinderGoals();
        }
        entity.setRabbitType(CraftMagicMapping.toMagic(type));
    }

    private static class CraftMagicMapping {
        private static final int[] types = new int[Rabbit.Type.values().length];
        private static final Rabbit.Type[] reverse = new Rabbit.Type[Rabbit.Type.values().length];

        static {
            CraftMagicMapping.set(Rabbit.Type.BROWN, 0);
            CraftMagicMapping.set(Rabbit.Type.WHITE, 1);
            CraftMagicMapping.set(Rabbit.Type.BLACK, 2);
            CraftMagicMapping.set(Rabbit.Type.BLACK_AND_WHITE, 3);
            CraftMagicMapping.set(Rabbit.Type.GOLD, 4);
            CraftMagicMapping.set(Rabbit.Type.SALT_AND_PEPPER, 5);
            CraftMagicMapping.set(Rabbit.Type.THE_KILLER_BUNNY, 99);
        }

        private CraftMagicMapping() {
        }

        private static void set(Rabbit.Type type, int value) {
            CraftMagicMapping.types[type.ordinal()] = value;
            if (value < reverse.length) {
                CraftMagicMapping.reverse[value] = type;
            }
        }

        public static Rabbit.Type fromMagic(int magic) {
            if (magic >= 0 && magic < reverse.length) {
                return reverse[magic];
            }
            if (magic == 99) {
                return Rabbit.Type.THE_KILLER_BUNNY;
            }
            return null;
        }

        public static int toMagic(Rabbit.Type type) {
            return types[type.ordinal()];
        }
    }
}

