/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import net.minecraft.server.v1_12_R1.ChatComponentText;
import net.minecraft.server.v1_12_R1.Container;
import net.minecraft.server.v1_12_R1.ContainerAnvil;
import net.minecraft.server.v1_12_R1.ContainerBeacon;
import net.minecraft.server.v1_12_R1.ContainerBrewingStand;
import net.minecraft.server.v1_12_R1.ContainerChest;
import net.minecraft.server.v1_12_R1.ContainerDispenser;
import net.minecraft.server.v1_12_R1.ContainerEnchantTable;
import net.minecraft.server.v1_12_R1.ContainerFurnace;
import net.minecraft.server.v1_12_R1.ContainerHopper;
import net.minecraft.server.v1_12_R1.ContainerShulkerBox;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.ItemStack;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_12_R1.PlayerInventory;
import net.minecraft.server.v1_12_R1.Slot;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class CraftContainer
extends Container {
    private final InventoryView view;
    private InventoryType cachedType;
    private String cachedTitle;
    private Container delegate;
    private final int cachedSize;

    public CraftContainer(InventoryView view, EntityHuman player, int id) {
        this.view = view;
        this.windowId = id;
        IInventory top = ((CraftInventory)view.getTopInventory()).getInventory();
        PlayerInventory bottom = (PlayerInventory)((CraftInventory)view.getBottomInventory()).getInventory();
        this.cachedType = view.getType();
        this.cachedTitle = view.getTitle();
        this.cachedSize = this.getSize();
        this.setupSlots(top, bottom, player);
    }

    public CraftContainer(final Inventory inventory, final EntityHuman player, int id) {
        this(new InventoryView(){

            @Override
            public Inventory getTopInventory() {
                return inventory;
            }

            @Override
            public Inventory getBottomInventory() {
                return this.getPlayer().getInventory();
            }

            @Override
            public HumanEntity getPlayer() {
                return player.getBukkitEntity();
            }

            @Override
            public InventoryType getType() {
                return inventory.getType();
            }
        }, player, id);
    }

    public InventoryView getBukkitView() {
        return this.view;
    }

    private int getSize() {
        return this.view.getTopInventory().getSize();
    }

    public boolean c(EntityHuman entityhuman) {
        if (this.cachedType == this.view.getType() && this.cachedSize == this.getSize() && this.cachedTitle.equals(this.view.getTitle())) {
            return true;
        }
        boolean typeChanged = this.cachedType != this.view.getType();
        this.cachedType = this.view.getType();
        this.cachedTitle = this.view.getTitle();
        if (this.view.getPlayer() instanceof CraftPlayer) {
            CraftPlayer player = (CraftPlayer)this.view.getPlayer();
            String type = CraftContainer.getNotchInventoryType(this.cachedType);
            IInventory top = ((CraftInventory)this.view.getTopInventory()).getInventory();
            PlayerInventory bottom = (PlayerInventory)((CraftInventory)this.view.getBottomInventory()).getInventory();
            this.items.clear();
            this.slots.clear();
            if (typeChanged) {
                this.setupSlots(top, bottom, (EntityHuman)player.getHandle());
            }
            int size = this.getSize();
            player.getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(this.windowId, type, (IChatBaseComponent)new ChatComponentText(this.cachedTitle), size));
            player.updateInventory();
        }
        return true;
    }

    public static String getNotchInventoryType(InventoryType type) {
        switch (type) {
            case WORKBENCH: {
                return "minecraft:crafting_table";
            }
            case FURNACE: {
                return "minecraft:furnace";
            }
            case DISPENSER: {
                return "minecraft:dispenser";
            }
            case ENCHANTING: {
                return "minecraft:enchanting_table";
            }
            case BREWING: {
                return "minecraft:brewing_stand";
            }
            case BEACON: {
                return "minecraft:beacon";
            }
            case ANVIL: {
                return "minecraft:anvil";
            }
            case HOPPER: {
                return "minecraft:hopper";
            }
            case DROPPER: {
                return "minecraft:dropper";
            }
            case SHULKER_BOX: {
                return "minecraft:shulker_box";
            }
        }
        return "minecraft:chest";
    }

    private void setupSlots(IInventory top, PlayerInventory bottom, EntityHuman entityhuman) {
        switch (this.cachedType) {
            case CREATIVE: {
                break;
            }
            case CHEST: 
            case PLAYER: {
                this.delegate = new ContainerChest((IInventory)bottom, top, entityhuman);
                break;
            }
            case DISPENSER: 
            case DROPPER: {
                this.delegate = new ContainerDispenser((IInventory)bottom, top);
                break;
            }
            case FURNACE: {
                this.delegate = new ContainerFurnace(bottom, top);
                break;
            }
            case WORKBENCH: 
            case CRAFTING: {
                this.setupWorkbench(top, (IInventory)bottom);
                break;
            }
            case ENCHANTING: {
                this.delegate = new ContainerEnchantTable(bottom, entityhuman.world, entityhuman.getChunkCoordinates());
                break;
            }
            case BREWING: {
                this.delegate = new ContainerBrewingStand(bottom, top);
                break;
            }
            case HOPPER: {
                this.delegate = new ContainerHopper(bottom, top, entityhuman);
                break;
            }
            case ANVIL: {
                this.delegate = new ContainerAnvil(bottom, entityhuman.world, entityhuman.getChunkCoordinates(), entityhuman);
                break;
            }
            case BEACON: {
                this.delegate = new ContainerBeacon((IInventory)bottom, top);
                break;
            }
            case SHULKER_BOX: {
                this.delegate = new ContainerShulkerBox(bottom, top, entityhuman);
            }
        }
        if (this.delegate != null) {
            this.items = this.delegate.items;
            this.slots = this.delegate.slots;
        }
    }

    private void setupWorkbench(IInventory top, IInventory bottom) {
        int col;
        this.a(new Slot(top, 0, 124, 35));
        int row = 0;
        while (row < 3) {
            col = 0;
            while (col < 3) {
                this.a(new Slot(top, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
                ++col;
            }
            ++row;
        }
        row = 0;
        while (row < 3) {
            col = 0;
            while (col < 9) {
                this.a(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
                ++col;
            }
            ++row;
        }
        col = 0;
        while (col < 9) {
            this.a(new Slot(bottom, col, 8 + col * 18, 142));
            ++col;
        }
    }

    public ItemStack shiftClick(EntityHuman entityhuman, int i) {
        return this.delegate != null ? this.delegate.shiftClick(entityhuman, i) : super.shiftClick(entityhuman, i);
    }

    public boolean canUse(EntityHuman entity) {
        return true;
    }
}

