/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.server.v1_12_R1.IHopper;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.InventoryCrafting;
import net.minecraft.server.v1_12_R1.InventoryEnderChest;
import net.minecraft.server.v1_12_R1.InventoryMerchant;
import net.minecraft.server.v1_12_R1.PlayerInventory;
import net.minecraft.server.v1_12_R1.TileEntityBeacon;
import net.minecraft.server.v1_12_R1.TileEntityBrewingStand;
import net.minecraft.server.v1_12_R1.TileEntityDispenser;
import net.minecraft.server.v1_12_R1.TileEntityDropper;
import net.minecraft.server.v1_12_R1.TileEntityFurnace;
import net.minecraft.server.v1_12_R1.TileEntityShulkerBox;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.inventory.InventoryIterator;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CraftInventory
implements Inventory {
    protected final IInventory inventory;

    public CraftInventory(IInventory inventory) {
        this.inventory = inventory;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public int getSize() {
        return this.getInventory().getSize();
    }

    @Override
    public String getName() {
        return this.getInventory().getName();
    }

    @Override
    public ItemStack getItem(int index) {
        net.minecraft.server.v1_12_R1.ItemStack item = this.getInventory().getItem(index);
        return item.isEmpty() ? null : CraftItemStack.asCraftMirror(item);
    }

    protected ItemStack[] asCraftMirror(List<net.minecraft.server.v1_12_R1.ItemStack> mcItems) {
        int size = mcItems.size();
        ItemStack[] items = new ItemStack[size];
        int i = 0;
        while (i < size) {
            net.minecraft.server.v1_12_R1.ItemStack mcItem = mcItems.get(i);
            items[i] = mcItem.isEmpty() ? null : CraftItemStack.asCraftMirror(mcItem);
            ++i;
        }
        return items;
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.getContents();
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setContents(items);
    }

    @Override
    public ItemStack[] getContents() {
        List mcItems = this.getInventory().getContents();
        return this.asCraftMirror(mcItems);
    }

    @Override
    public void setContents(ItemStack[] items) {
        if (this.getSize() < items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getSize() + " or less");
        }
        int i = 0;
        while (i < this.getSize()) {
            if (i >= items.length) {
                this.setItem(i, null);
            } else {
                this.setItem(i, items[i]);
            }
            ++i;
        }
    }

    @Override
    public void setItem(int index, ItemStack item) {
        this.getInventory().setItem(index, CraftItemStack.asNMSCopy(item));
    }

    @Override
    public boolean contains(int materialId) {
        ItemStack[] itemStackArray = this.getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getTypeId() == materialId) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean contains(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.contains(material.getId());
    }

    @Override
    public boolean contains(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (item.equals(i)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean contains(int materialId, int amount) {
        if (amount <= 0) {
            return true;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getTypeId() == materialId && (amount -= item.getAmount()) <= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean contains(Material material, int amount) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.contains(material.getId(), amount);
    }

    @Override
    public boolean contains(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (item.equals(i) && --amount <= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (item.isSimilar(i) && (amount -= i.getAmount()) <= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public HashMap<Integer, ItemStack> all(int materialId) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        ItemStack[] inventory = this.getStorageContents();
        int i = 0;
        while (i < inventory.length) {
            ItemStack item = inventory[i];
            if (item != null && item.getTypeId() == materialId) {
                slots.put(i, item);
            }
            ++i;
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> all(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.all(material.getId());
    }

    public HashMap<Integer, ItemStack> all(ItemStack item) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        if (item != null) {
            ItemStack[] inventory = this.getStorageContents();
            int i = 0;
            while (i < inventory.length) {
                if (item.equals(inventory[i])) {
                    slots.put(i, inventory[i]);
                }
                ++i;
            }
        }
        return slots;
    }

    @Override
    public int first(int materialId) {
        ItemStack[] inventory = this.getStorageContents();
        int i = 0;
        while (i < inventory.length) {
            ItemStack item = inventory[i];
            if (item != null && item.getTypeId() == materialId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int first(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.first(material.getId());
    }

    @Override
    public int first(ItemStack item) {
        return this.first(item, true);
    }

    private int first(ItemStack item, boolean withAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] inventory = this.getStorageContents();
        int i = 0;
        while (i < inventory.length) {
            if (inventory[i] != null && (withAmount ? item.equals(inventory[i]) : item.isSimilar(inventory[i]))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int firstEmpty() {
        ItemStack[] inventory = this.getStorageContents();
        int i = 0;
        while (i < inventory.length) {
            if (inventory[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int firstPartial(int materialId) {
        ItemStack[] inventory = this.getStorageContents();
        int i = 0;
        while (i < inventory.length) {
            ItemStack item = inventory[i];
            if (item != null && item.getTypeId() == materialId && item.getAmount() < item.getMaxStackSize()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int firstPartial(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.firstPartial(material.getId());
    }

    private int firstPartial(ItemStack item) {
        ItemStack[] inventory = this.getStorageContents();
        CraftItemStack filteredItem = CraftItemStack.asCraftCopy(item);
        if (item == null) {
            return -1;
        }
        int i = 0;
        while (i < inventory.length) {
            ItemStack cItem = inventory[i];
            if (cItem != null && cItem.getAmount() < cItem.getMaxStackSize() && cItem.isSimilar(filteredItem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) {
        Validate.noNullElements((Object[])items, (String)"Item cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        int i = 0;
        while (i < items.length) {
            ItemStack item = items[i];
            while (true) {
                int maxAmount;
                int partialAmount;
                int firstPartial;
                if ((firstPartial = this.firstPartial(item)) == -1) {
                    int firstFree = this.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i, item);
                        break;
                    }
                    if (item.getAmount() > this.getMaxItemStack()) {
                        CraftItemStack stack = CraftItemStack.asCraftCopy(item);
                        stack.setAmount(this.getMaxItemStack());
                        this.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - this.getMaxItemStack());
                        continue;
                    }
                    this.setItem(firstFree, item);
                    break;
                }
                ItemStack partialItem = this.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= (maxAmount = partialItem.getMaxStackSize())) {
                    partialItem.setAmount(amount + partialAmount);
                    this.setItem(firstPartial, partialItem);
                    break;
                }
                partialItem.setAmount(maxAmount);
                this.setItem(firstPartial, partialItem);
                item.setAmount(amount + partialAmount - maxAmount);
            }
            ++i;
        }
        return leftover;
    }

    @Override
    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) {
        Validate.notNull((Object)items, (String)"Items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        int i = 0;
        while (i < items.length) {
            ItemStack item = items[i];
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = this.first(item, false)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    break;
                }
                ItemStack itemStack = this.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    this.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                this.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
            ++i;
        }
        return leftover;
    }

    private int getMaxItemStack() {
        return this.getInventory().getMaxStackSize();
    }

    @Override
    public void remove(int materialId) {
        ItemStack[] items = this.getStorageContents();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && items[i].getTypeId() == materialId) {
                this.clear(i);
            }
            ++i;
        }
    }

    @Override
    public void remove(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        this.remove(material.getId());
    }

    @Override
    public void remove(ItemStack item) {
        ItemStack[] items = this.getStorageContents();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && items[i].equals(item)) {
                this.clear(i);
            }
            ++i;
        }
    }

    @Override
    public void clear(int index) {
        this.setItem(index, null);
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.getSize()) {
            this.clear(i);
            ++i;
        }
    }

    @Override
    public ListIterator<ItemStack> iterator() {
        return new InventoryIterator(this);
    }

    @Override
    public ListIterator<ItemStack> iterator(int index) {
        if (index < 0) {
            index += this.getSize() + 1;
        }
        return new InventoryIterator(this, index);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.inventory.getViewers();
    }

    @Override
    public String getTitle() {
        return this.inventory.getName();
    }

    @Override
    public InventoryType getType() {
        if (this.inventory instanceof InventoryCrafting) {
            return this.inventory.getSize() >= 9 ? InventoryType.WORKBENCH : InventoryType.CRAFTING;
        }
        if (this.inventory instanceof PlayerInventory) {
            return InventoryType.PLAYER;
        }
        if (this.inventory instanceof TileEntityDropper) {
            return InventoryType.DROPPER;
        }
        if (this.inventory instanceof TileEntityDispenser) {
            return InventoryType.DISPENSER;
        }
        if (this.inventory instanceof TileEntityFurnace) {
            return InventoryType.FURNACE;
        }
        if (this instanceof CraftInventoryEnchanting) {
            return InventoryType.ENCHANTING;
        }
        if (this.inventory instanceof TileEntityBrewingStand) {
            return InventoryType.BREWING;
        }
        if (this.inventory instanceof CraftInventoryCustom.MinecraftInventory) {
            return ((CraftInventoryCustom.MinecraftInventory)this.inventory).getType();
        }
        if (this.inventory instanceof InventoryEnderChest) {
            return InventoryType.ENDER_CHEST;
        }
        if (this.inventory instanceof InventoryMerchant) {
            return InventoryType.MERCHANT;
        }
        if (this.inventory instanceof TileEntityBeacon) {
            return InventoryType.BEACON;
        }
        if (this instanceof CraftInventoryAnvil) {
            return InventoryType.ANVIL;
        }
        if (this.inventory instanceof IHopper) {
            return InventoryType.HOPPER;
        }
        if (this.inventory instanceof TileEntityShulkerBox) {
            return InventoryType.SHULKER_BOX;
        }
        return InventoryType.CHEST;
    }

    @Override
    public InventoryHolder getHolder() {
        return this.inventory.getOwner();
    }

    @Override
    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    @Override
    public void setMaxStackSize(int size) {
        this.inventory.setMaxStackSize(size);
    }

    public int hashCode() {
        return this.inventory.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftInventory && ((CraftInventory)obj).inventory.equals(this.inventory);
    }

    @Override
    public Location getLocation() {
        return this.inventory.getLocation();
    }
}

