/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.v1_12_R1.EnchantmentManager;
import net.minecraft.server.v1_12_R1.Item;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagList;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_12_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    net.minecraft.server.v1_12_R1.ItemStack handle;

    public static net.minecraft.server.v1_12_R1.ItemStack asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? net.minecraft.server.v1_12_R1.ItemStack.a : stack.handle.cloneItemStack();
        }
        if (original == null || original.getTypeId() <= 0) {
            return net.minecraft.server.v1_12_R1.ItemStack.a;
        }
        Item item = CraftMagicNumbers.getItem(original.getType());
        if (item == null) {
            return net.minecraft.server.v1_12_R1.ItemStack.a;
        }
        net.minecraft.server.v1_12_R1.ItemStack stack = new net.minecraft.server.v1_12_R1.ItemStack(item, original.getAmount(), (int)original.getDurability(), false);
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        } else {
            stack.convertStack();
        }
        return stack;
    }

    public static net.minecraft.server.v1_12_R1.ItemStack copyNMSStack(net.minecraft.server.v1_12_R1.ItemStack original, int amount) {
        net.minecraft.server.v1_12_R1.ItemStack stack = original.cloneItemStack();
        stack.setCount(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(net.minecraft.server.v1_12_R1.ItemStack original) {
        if (original.isEmpty()) {
            return new ItemStack(Material.AIR);
        }
        ItemStack stack = new ItemStack(CraftMagicNumbers.getMaterial(original.getItem()), original.getCount(), (short)original.getData());
        if (CraftItemStack.hasItemMeta(original)) {
            stack.setItemMeta(CraftItemStack.getItemMeta(original));
        }
        return stack;
    }

    public static CraftItemStack asCraftMirror(net.minecraft.server.v1_12_R1.ItemStack original) {
        return new CraftItemStack(original == null || original.isEmpty() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.cloneItemStack());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(Item item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(Item item, int amount) {
        return new CraftItemStack(CraftMagicNumbers.getMaterial(item), amount, 0, null);
    }

    private CraftItemStack(net.minecraft.server.v1_12_R1.ItemStack item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getTypeId(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    private CraftItemStack(int typeId, int amount, short durability, ItemMeta itemMeta) {
        this(Material.getMaterial(typeId), amount, durability, itemMeta);
    }

    @Override
    public int getTypeId() {
        return this.handle != null ? CraftMagicNumbers.getId(this.handle.getItem()) : 0;
    }

    @Override
    public void setTypeId(int type) {
        if (this.getTypeId() == type) {
            return;
        }
        if (type == 0) {
            this.handle = null;
        } else if (CraftMagicNumbers.getItem(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new net.minecraft.server.v1_12_R1.ItemStack(CraftMagicNumbers.getItem(type), 1, 0);
        } else {
            this.handle.setItem(CraftMagicNumbers.getItem(type));
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    @Override
    public int getAmount() {
        return this.handle != null ? this.handle.getCount() : 0;
    }

    @Override
    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.setCount(amount);
        if (amount == 0) {
            this.handle = null;
        }
    }

    @Override
    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.setData((int)durability);
        }
    }

    @Override
    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.getData();
        }
        return -1;
    }

    @Override
    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.getItem().getMaxStackSize();
    }

    @Override
    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Validate.notNull((Object)ench, (String)"Cannot add null enchantment");
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        NBTTagList list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = new NBTTagList();
            this.handle.getTag().set(CraftMetaItem.ENCHANTMENTS.NBT, (NBTBase)list);
        }
        int size = list.size();
        int i = 0;
        while (i < size) {
            NBTTagCompound tag = list.get(i);
            short id = tag.getShort(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id == ench.getId()) {
                tag.setShort(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
                return;
            }
            ++i;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.setShort(CraftMetaItem.ENCHANTMENTS_ID.NBT, (short)ench.getId());
        tag.setShort(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
        list.add((NBTBase)tag);
    }

    static boolean makeTag(net.minecraft.server.v1_12_R1.ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getTag() == null) {
            item.setTag(new NBTTagCompound());
        }
        return true;
    }

    @Override
    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    @Override
    public int getEnchantmentLevel(Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Cannot find null enchantment");
        if (this.handle == null) {
            return 0;
        }
        return EnchantmentManager.getEnchantmentLevel((net.minecraft.server.v1_12_R1.Enchantment)CraftEnchantment.getRaw(ench), (net.minecraft.server.v1_12_R1.ItemStack)this.handle);
    }

    @Override
    public int removeEnchantment(Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Cannot remove null enchantment");
        NBTTagList list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int index = Integer.MIN_VALUE;
        int level = Integer.MIN_VALUE;
        int size = list.size();
        int i = 0;
        while (i < size) {
            NBTTagCompound enchantment = list.get(i);
            int id = 0xFFFF & enchantment.getShort(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id == ench.getId()) {
                index = i;
                level = 0xFFFF & enchantment.getShort(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
                break;
            }
            ++i;
        }
        if (index == Integer.MIN_VALUE) {
            return 0;
        }
        if (size == 1) {
            this.handle.getTag().remove(CraftMetaItem.ENCHANTMENTS.NBT);
            if (this.handle.getTag().isEmpty()) {
                this.handle.setTag(null);
            }
            return level;
        }
        NBTTagList listCopy = new NBTTagList();
        i = 0;
        while (i < size) {
            if (i != index) {
                listCopy.add((NBTBase)list.get(i));
            }
            ++i;
        }
        this.handle.getTag().set(CraftMetaItem.ENCHANTMENTS.NBT, (NBTBase)listCopy);
        return level;
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<Enchantment, Integer> getEnchantments(net.minecraft.server.v1_12_R1.ItemStack item) {
        NBTTagList list;
        NBTTagList nBTTagList = list = item != null && item.hasEnchantments() ? item.getEnchantments() : null;
        if (list == null || list.size() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        int i = 0;
        while (i < list.size()) {
            int id = 0xFFFF & list.get(i).getShort(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & list.get(i).getShort(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            result.put((Object)Enchantment.getById(id), (Object)level);
            ++i;
        }
        return result.build();
    }

    static NBTTagList getEnchantmentList(net.minecraft.server.v1_12_R1.ItemStack item) {
        return item != null && item.hasEnchantments() ? item.getEnchantments() : null;
    }

    @Override
    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.cloneItemStack();
        }
        return itemStack;
    }

    @Override
    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(net.minecraft.server.v1_12_R1.ItemStack item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        switch (CraftItemStack.getType(item)) {
            case WRITTEN_BOOK: {
                return new CraftMetaBookSigned(item.getTag());
            }
            case BOOK_AND_QUILL: {
                return new CraftMetaBook(item.getTag());
            }
            case SKULL_ITEM: {
                return new CraftMetaSkull(item.getTag());
            }
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return new CraftMetaLeatherArmor(item.getTag());
            }
            case POTION: 
            case SPLASH_POTION: 
            case TIPPED_ARROW: 
            case LINGERING_POTION: {
                return new CraftMetaPotion(item.getTag());
            }
            case MAP: {
                return new CraftMetaMap(item.getTag());
            }
            case FIREWORK: {
                return new CraftMetaFirework(item.getTag());
            }
            case FIREWORK_CHARGE: {
                return new CraftMetaCharge(item.getTag());
            }
            case ENCHANTED_BOOK: {
                return new CraftMetaEnchantedBook(item.getTag());
            }
            case BANNER: {
                return new CraftMetaBanner(item.getTag());
            }
            case MONSTER_EGG: {
                return new CraftMetaSpawnEgg(item.getTag());
            }
            case KNOWLEDGE_BOOK: {
                return new CraftMetaKnowledgeBook(item.getTag());
            }
            case DISPENSER: 
            case NOTE_BLOCK: 
            case MOB_SPAWNER: 
            case CHEST: 
            case FURNACE: 
            case JUKEBOX: 
            case ENCHANTMENT_TABLE: 
            case ENDER_CHEST: 
            case COMMAND: 
            case BEACON: 
            case TRAPPED_CHEST: 
            case DAYLIGHT_DETECTOR: 
            case HOPPER: 
            case DROPPER: 
            case DAYLIGHT_DETECTOR_INVERTED: 
            case COMMAND_REPEATING: 
            case COMMAND_CHAIN: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case SILVER_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case STRUCTURE_BLOCK: 
            case SIGN: 
            case BREWING_STAND_ITEM: 
            case FLOWER_POT_ITEM: 
            case REDSTONE_COMPARATOR: 
            case SHIELD: {
                return new CraftMetaBlockState(item.getTag(), CraftMagicNumbers.getMaterial(item.getItem()));
            }
        }
        return new CraftMetaItem(item.getTag());
    }

    static Material getType(net.minecraft.server.v1_12_R1.ItemStack item) {
        Material material = Material.getMaterial(item == null ? 0 : CraftMagicNumbers.getId(item.getItem()));
        return material == null ? Material.AIR : material;
    }

    @Override
    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(net.minecraft.server.v1_12_R1.ItemStack item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.setTag(null);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        NBTTagCompound tag = new NBTTagCompound();
        item.setTag(tag);
        ((CraftMetaItem)itemMeta).applyToItem(tag);
        item.convertStack();
        return true;
    }

    @Override
    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar(this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        if (that.getTypeId() != this.getTypeId() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.getTag().equals((Object)that.handle.getTag()) : !that.hasItemMeta();
    }

    @Override
    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle);
    }

    static boolean hasItemMeta(net.minecraft.server.v1_12_R1.ItemStack item) {
        return item != null && item.getTag() != null && !item.getTag().isEmpty();
    }
}

