/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagList;
import net.minecraft.server.v1_12_R1.NBTTagString;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.BookMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaBookSigned
extends CraftMetaBook
implements BookMeta {
    CraftMetaBookSigned(CraftMetaItem meta) {
        super(meta);
    }

    CraftMetaBookSigned(NBTTagCompound tag) {
        super(tag, false);
        boolean resolved = true;
        if (tag.hasKey(CraftMetaBookSigned.RESOLVED.NBT)) {
            resolved = tag.getBoolean(CraftMetaBookSigned.RESOLVED.NBT);
        }
        if (tag.hasKey(CraftMetaBookSigned.BOOK_PAGES.NBT)) {
            NBTTagList pages = tag.getList(CraftMetaBookSigned.BOOK_PAGES.NBT, 8);
            int i = 0;
            while (i < Math.min(pages.size(), 50)) {
                String page = pages.getString(i);
                if (resolved) {
                    try {
                        this.pages.add(IChatBaseComponent.ChatSerializer.a((String)page));
                    }
                    catch (Exception exception) {}
                }
                this.addPage(page);
                ++i;
            }
        }
    }

    CraftMetaBookSigned(Map<String, Object> map) {
        super(map);
    }

    @Override
    void applyToItem(NBTTagCompound itemData) {
        super.applyToItem(itemData, false);
        if (this.hasTitle()) {
            itemData.setString(CraftMetaBookSigned.BOOK_TITLE.NBT, this.title);
        } else {
            itemData.setString(CraftMetaBookSigned.BOOK_TITLE.NBT, " ");
        }
        if (this.hasAuthor()) {
            itemData.setString(CraftMetaBookSigned.BOOK_AUTHOR.NBT, this.author);
        } else {
            itemData.setString(CraftMetaBookSigned.BOOK_AUTHOR.NBT, " ");
        }
        if (this.hasPages()) {
            NBTTagList list = new NBTTagList();
            for (IChatBaseComponent page : this.pages) {
                list.add((NBTBase)new NBTTagString(IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)page)));
            }
            itemData.set(CraftMetaBookSigned.BOOK_PAGES.NBT, (NBTBase)list);
        }
        itemData.setBoolean(CraftMetaBookSigned.RESOLVED.NBT, true);
        if (this.generation != null) {
            itemData.setInt(CraftMetaBookSigned.GENERATION.NBT, this.generation.intValue());
        } else {
            itemData.setInt(CraftMetaBookSigned.GENERATION.NBT, 0);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case BOOK_AND_QUILL: 
            case WRITTEN_BOOK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CraftMetaBookSigned clone() {
        CraftMetaBookSigned meta = (CraftMetaBookSigned)super.clone();
        return meta;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        return original != hash ? CraftMetaBookSigned.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        return super.equalsCommon(meta);
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBookSigned || this.isBookEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        return builder;
    }
}

