/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagInt;
import net.minecraft.server.v1_12_R1.NBTTagString;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.MapMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaMap
extends CraftMetaItem
implements MapMeta {
    static final CraftMetaItem.ItemMetaKey MAP_SCALING = new CraftMetaItem.ItemMetaKey("map_is_scaling", "scaling");
    static final CraftMetaItem.ItemMetaKey MAP_LOC_NAME = new CraftMetaItem.ItemMetaKey("LocName", "display-loc-name");
    static final CraftMetaItem.ItemMetaKey MAP_COLOR = new CraftMetaItem.ItemMetaKey("MapColor", "display-map-color");
    static final byte SCALING_EMPTY = 0;
    static final byte SCALING_TRUE = 1;
    static final byte SCALING_FALSE = 2;
    private byte scaling = 0;
    private String locName;
    private Color color;

    CraftMetaMap(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaMap)) {
            return;
        }
        CraftMetaMap map = (CraftMetaMap)meta;
        this.scaling = map.scaling;
        this.locName = map.locName;
        this.color = map.color;
    }

    CraftMetaMap(NBTTagCompound tag) {
        super(tag);
        if (tag.hasKey(CraftMetaMap.MAP_SCALING.NBT)) {
            this.scaling = (byte)(tag.getBoolean(CraftMetaMap.MAP_SCALING.NBT) ? 1 : 2);
        }
        if (tag.hasKey(CraftMetaMap.DISPLAY.NBT)) {
            NBTTagCompound display = tag.getCompound(CraftMetaMap.DISPLAY.NBT);
            if (display.hasKey(CraftMetaMap.MAP_LOC_NAME.NBT)) {
                this.locName = display.getString(CraftMetaMap.MAP_LOC_NAME.NBT);
            }
            if (display.hasKey(CraftMetaMap.MAP_COLOR.NBT)) {
                this.color = Color.fromRGB(display.getInt(CraftMetaMap.MAP_COLOR.NBT));
            }
        }
    }

    CraftMetaMap(Map<String, Object> map) {
        super(map);
        Color color;
        String locName;
        Boolean scaling = CraftMetaItem.SerializableMeta.getObject(Boolean.class, map, CraftMetaMap.MAP_SCALING.BUKKIT, true);
        if (scaling != null) {
            this.setScaling(scaling);
        }
        if ((locName = CraftMetaItem.SerializableMeta.getString(map, CraftMetaMap.MAP_LOC_NAME.BUKKIT, true)) != null) {
            this.setLocationName(locName);
        }
        if ((color = CraftMetaItem.SerializableMeta.getObject(Color.class, map, CraftMetaMap.MAP_COLOR.BUKKIT, true)) != null) {
            this.setColor(color);
        }
    }

    @Override
    void applyToItem(NBTTagCompound tag) {
        super.applyToItem(tag);
        if (this.hasScaling()) {
            tag.setBoolean(CraftMetaMap.MAP_SCALING.NBT, this.isScaling());
        }
        if (this.hasLocationName()) {
            this.setDisplayTag(tag, CraftMetaMap.MAP_LOC_NAME.NBT, (NBTBase)new NBTTagString(this.getLocationName()));
        }
        if (this.hasColor()) {
            this.setDisplayTag(tag, CraftMetaMap.MAP_COLOR.NBT, (NBTBase)new NBTTagInt(this.color.asRGB()));
        }
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case MAP: {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isMapEmpty();
    }

    boolean isMapEmpty() {
        return !(this.hasScaling() | this.hasLocationName()) && !this.hasColor();
    }

    boolean hasScaling() {
        return this.scaling != 0;
    }

    @Override
    public boolean isScaling() {
        return this.scaling == 1;
    }

    @Override
    public void setScaling(boolean scaling) {
        this.scaling = (byte)(scaling ? 1 : 2);
    }

    @Override
    public boolean hasLocationName() {
        return this.locName != null;
    }

    @Override
    public String getLocationName() {
        return this.locName;
    }

    @Override
    public void setLocationName(String name) {
        this.locName = name;
    }

    @Override
    public boolean hasColor() {
        return this.color != null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaMap) {
            CraftMetaMap that = (CraftMetaMap)meta;
            return this.scaling == that.scaling && (this.hasLocationName() ? that.hasLocationName() && this.locName.equals(that.locName) : !that.hasLocationName()) && (this.hasColor() ? that.hasColor() && this.color.equals(that.color) : !that.hasColor());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaMap || this.isMapEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasScaling()) {
            hash ^= 0x22222222 << (this.isScaling() ? 1 : -1);
        }
        if (this.hasLocationName()) {
            hash = 61 * hash + this.locName.hashCode();
        }
        if (this.hasColor()) {
            hash = 61 * hash + this.color.hashCode();
        }
        return original != hash ? CraftMetaMap.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaMap clone() {
        return (CraftMetaMap)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasScaling()) {
            builder.put((Object)CraftMetaMap.MAP_SCALING.BUKKIT, (Object)this.isScaling());
        }
        if (this.hasLocationName()) {
            builder.put((Object)CraftMetaMap.MAP_LOC_NAME.BUKKIT, (Object)this.getLocationName());
        }
        if (this.hasColor()) {
            builder.put((Object)CraftMetaMap.MAP_COLOR.BUKKIT, (Object)this.getColor());
        }
        return builder;
    }
}

