/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.inventory;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.IInventory;
import net.minecraft.server.v1_12_R1.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class InventoryWrapper
implements IInventory {
    private final Inventory inventory;
    private final List<HumanEntity> viewers = new ArrayList<HumanEntity>();

    public InventoryWrapper(Inventory inventory) {
        this.inventory = inventory;
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public ItemStack getItem(int i) {
        return CraftItemStack.asNMSCopy(this.inventory.getItem(i));
    }

    public ItemStack splitStack(int i, int j) {
        ItemStack result;
        ItemStack stack = this.getItem(i);
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack.getCount() <= j) {
            this.setItem(i, ItemStack.a);
            result = stack;
        } else {
            result = CraftItemStack.copyNMSStack(stack, j);
            stack.subtract(j);
        }
        this.update();
        return result;
    }

    public ItemStack splitWithoutUpdate(int i) {
        ItemStack result;
        ItemStack stack = this.getItem(i);
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack.getCount() <= 1) {
            this.setItem(i, ItemStack.a);
            result = stack;
        } else {
            result = CraftItemStack.copyNMSStack(stack, 1);
            stack.subtract(1);
        }
        return result;
    }

    public void setItem(int i, ItemStack itemstack) {
        this.inventory.setItem(i, CraftItemStack.asBukkitCopy(itemstack));
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public void update() {
    }

    public boolean a(EntityHuman entityhuman) {
        return true;
    }

    public void startOpen(EntityHuman entityhuman) {
    }

    public void closeContainer(EntityHuman entityhuman) {
    }

    public boolean b(int i, ItemStack itemstack) {
        return true;
    }

    public int getProperty(int i) {
        return 0;
    }

    public void setProperty(int i, int j) {
    }

    public int h() {
        return 0;
    }

    public void clear() {
        this.inventory.clear();
    }

    public List<ItemStack> getContents() {
        int size = this.getSize();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(size);
        int i = 0;
        while (i < size) {
            items.set(i, this.getItem(i));
            ++i;
        }
        return items;
    }

    public void onOpen(CraftHumanEntity who) {
        this.viewers.add(who);
    }

    public void onClose(CraftHumanEntity who) {
        this.viewers.remove(who);
    }

    public List<HumanEntity> getViewers() {
        return this.viewers;
    }

    public InventoryHolder getOwner() {
        return this.inventory.getHolder();
    }

    public void setMaxStackSize(int size) {
        this.inventory.setMaxStackSize(size);
    }

    public String getName() {
        return this.inventory.getName();
    }

    public boolean hasCustomName() {
        return this.getName() != null;
    }

    public IChatBaseComponent getScoreboardDisplayName() {
        return CraftChatMessage.fromString(this.getName())[0];
    }

    public Location getLocation() {
        return this.inventory.getLocation();
    }

    public boolean x_() {
        return Iterables.any((Iterable)this.inventory, (Predicate)Predicates.notNull());
    }
}

