/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.scoreboard;

import net.minecraft.server.v1_12_R1.Scoreboard;
import net.minecraft.server.v1_12_R1.ScoreboardObjective;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScoreboardTranslations;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;

final class CraftObjective
extends CraftScoreboardComponent
implements Objective {
    private final ScoreboardObjective objective;
    private final CraftCriteria criteria;

    CraftObjective(CraftScoreboard scoreboard, ScoreboardObjective objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CraftCriteria.getFromNMS(objective);
    }

    ScoreboardObjective getHandle() {
        return this.objective;
    }

    @Override
    public String getName() throws IllegalStateException {
        this.checkState();
        return this.objective.getName();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        this.checkState();
        return this.objective.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.isTrue((displayName.length() <= 32 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 32 characters"));
        this.checkState();
        this.objective.setDisplayName(displayName);
    }

    @Override
    public String getCriteria() throws IllegalStateException {
        this.checkState();
        return this.criteria.bukkitName;
    }

    @Override
    public boolean isModifiable() throws IllegalStateException {
        this.checkState();
        return !this.criteria.criteria.isReadOnly();
    }

    @Override
    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        Scoreboard board = scoreboard.board;
        ScoreboardObjective objective = this.objective;
        int i = 0;
        while (i < 3) {
            if (board.getObjectiveForSlot(i) == objective) {
                board.setDisplaySlot(i, null);
            }
            ++i;
        }
        if (slot != null) {
            int slotNumber = CraftScoreboardTranslations.fromBukkitSlot(slot);
            board.setDisplaySlot(slotNumber, this.getHandle());
        }
    }

    @Override
    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        Scoreboard board = scoreboard.board;
        ScoreboardObjective objective = this.objective;
        int i = 0;
        while (i < 3) {
            if (board.getObjectiveForSlot(i) == objective) {
                return CraftScoreboardTranslations.toBukkitSlot(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Score getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"Player cannot be null");
        this.checkState();
        return new CraftScore(this, player.getName());
    }

    @Override
    public Score getScore(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        if (entry.length() > 40) {
            throw new IllegalArgumentException("Entry cannot be longer than 40 characters!");
        }
        this.checkState();
        return new CraftScore(this, entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.unregisterObjective(this.objective);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        if (((CraftScoreboard)this.getScoreboard()).board.getObjective(this.objective.getName()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.objective != null ? this.objective.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftObjective other = (CraftObjective)obj;
        return this.objective == other.objective || this.objective != null && this.objective.equals(other.objective);
    }
}

