/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.scoreboard;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.IScoreboardCriteria;
import net.minecraft.server.v1_12_R1.MinecraftServer;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_12_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_12_R1.ScoreboardObjective;
import net.minecraft.server.v1_12_R1.ScoreboardScore;
import net.minecraft.server.v1_12_R1.ScoreboardServer;
import net.minecraft.server.v1_12_R1.ScoreboardTeam;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_12_R1.util.WeakCollection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.spigotmc.AsyncCatcher;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();
    private final Map<CraftPlayer, CraftScoreboard> playerBoards = new HashMap<CraftPlayer, CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer minecraftserver, net.minecraft.server.v1_12_R1.Scoreboard scoreboardServer) {
        this.mainScoreboard = new CraftScoreboard(scoreboardServer);
        this.server = minecraftserver;
        this.scoreboards.add(this.mainScoreboard);
    }

    @Override
    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    @Override
    public CraftScoreboard getNewScoreboard() {
        AsyncCatcher.catchOp("scoreboard creation");
        CraftScoreboard scoreboard = new CraftScoreboard((net.minecraft.server.v1_12_R1.Scoreboard)new ScoreboardServer(this.server));
        this.scoreboards.add(scoreboard);
        return scoreboard;
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, Scoreboard bukkitScoreboard) throws IllegalArgumentException {
        Validate.isTrue((boolean)(bukkitScoreboard instanceof CraftScoreboard), (String)"Cannot set player scoreboard to an unregistered Scoreboard");
        CraftScoreboard scoreboard = (CraftScoreboard)bukkitScoreboard;
        net.minecraft.server.v1_12_R1.Scoreboard oldboard = this.getPlayerBoard(player).getHandle();
        net.minecraft.server.v1_12_R1.Scoreboard newboard = scoreboard.getHandle();
        EntityPlayer entityplayer = player.getHandle();
        if (oldboard == newboard) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        HashSet<ScoreboardObjective> removed = new HashSet<ScoreboardObjective>();
        int i = 0;
        while (i < 3) {
            ScoreboardObjective scoreboardobjective = oldboard.getObjectiveForSlot(i);
            if (scoreboardobjective != null && !removed.contains(scoreboardobjective)) {
                entityplayer.playerConnection.sendPacket((Packet)new PacketPlayOutScoreboardObjective(scoreboardobjective, 1));
                removed.add(scoreboardobjective);
            }
            ++i;
        }
        for (ScoreboardTeam scoreboardteam : oldboard.getTeams()) {
            entityplayer.playerConnection.sendPacket((Packet)new PacketPlayOutScoreboardTeam(scoreboardteam, 1));
        }
        this.server.getPlayerList().sendScoreboard((ScoreboardServer)newboard, player.getHandle());
    }

    public void removePlayer(Player player) {
        this.playerBoards.remove(player);
    }

    public Collection<ScoreboardScore> getScoreboardScores(IScoreboardCriteria criteria, String name, Collection<ScoreboardScore> collection) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            net.minecraft.server.v1_12_R1.Scoreboard board = scoreboard.board;
            for (ScoreboardObjective objective : board.getObjectivesForCriteria(criteria)) {
                collection.add(board.getPlayerScoreForObjective(name, objective));
            }
        }
        return collection;
    }
}

