/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenEvent
extends Event {
    private final blk gui;

    public GuiScreenEvent(blk gui) {
        this.gui = gui;
    }

    public blk getGui() {
        return this.gui;
    }

    public static class KeyboardInputEvent
    extends GuiScreenEvent {
        public KeyboardInputEvent(blk gui) {
            super(gui);
        }

        @Cancelable
        public static class Post
        extends KeyboardInputEvent {
            public Post(blk gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardInputEvent {
            public Pre(blk gui) {
                super(gui);
            }
        }
    }

    public static class MouseInputEvent
    extends GuiScreenEvent {
        public MouseInputEvent(blk gui) {
            super(gui);
        }

        @Cancelable
        public static class Post
        extends MouseInputEvent {
            public Post(blk gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseInputEvent {
            public Pre(blk gui) {
                super(gui);
            }
        }
    }

    public static class ActionPerformedEvent
    extends GuiScreenEvent {
        private bja button;
        private List<bja> buttonList;

        public ActionPerformedEvent(blk gui, bja button, List<bja> buttonList) {
            super(gui);
            this.setButton(button);
            this.setButtonList(new ArrayList<bja>(buttonList));
        }

        public bja getButton() {
            return this.button;
        }

        public void setButton(bja button) {
            this.button = button;
        }

        public List<bja> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<bja> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends ActionPerformedEvent {
            public Post(blk gui, bja button, List<bja> buttonList) {
                super(gui, button, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends ActionPerformedEvent {
            public Pre(blk gui, bja button, List<bja> buttonList) {
                super(gui, button, buttonList);
            }
        }
    }

    @Cancelable
    public static class PotionShiftEvent
    extends GuiScreenEvent {
        public PotionShiftEvent(blk gui) {
            super(gui);
        }
    }

    public static class BackgroundDrawnEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;

        public BackgroundDrawnEvent(blk gui) {
            super(gui);
            bit scaledresolution = new bit(gui.j);
            int scaledWidth = scaledresolution.a();
            int scaledHeight = scaledresolution.b();
            this.mouseX = Mouse.getX() * scaledWidth / gui.j.d;
            this.mouseY = scaledHeight - Mouse.getY() * scaledHeight / gui.j.e - 1;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }
    }

    public static class DrawScreenEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;
        private final float renderPartialTicks;

        public DrawScreenEvent(blk gui, int mouseX, int mouseY, float renderPartialTicks) {
            super(gui);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.renderPartialTicks = renderPartialTicks;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getRenderPartialTicks() {
            return this.renderPartialTicks;
        }

        public static class Post
        extends DrawScreenEvent {
            public Post(blk gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }

        @Cancelable
        public static class Pre
        extends DrawScreenEvent {
            public Pre(blk gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }
    }

    public static class InitGuiEvent
    extends GuiScreenEvent {
        private List<bja> buttonList;

        public InitGuiEvent(blk gui, List<bja> buttonList) {
            super(gui);
            this.setButtonList(buttonList);
        }

        public List<bja> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<bja> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends InitGuiEvent {
            public Post(blk gui, List<bja> buttonList) {
                super(gui, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends InitGuiEvent {
            public Pre(blk gui, List<bja> buttonList) {
                super(gui, buttonList);
            }
        }
    }
}

