/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import catserver.server.CatServer;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CatGradleStart {
    protected static Logger LOGGER = LogManager.getLogger((String)"GradleStart");
    Map<String, String> argMap = Maps.newHashMap();
    List<String> extras = Lists.newArrayList();
    static final File SRG_SRG_MCP = new File(CatGradleStart.class.getClassLoader().getResource("mappings/" + CatServer.getNativeVersion() + "/srg2mcp.srg").getFile());

    public static void main(String[] args) throws Throwable {
        new CatGradleStart().launch(args);
    }

    protected void launch(String[] args) throws Throwable {
        System.setProperty("net.minecraftforge.gradle.GradleStart.srg.srg-mcp", SRG_SRG_MCP.getCanonicalPath());
        this.parseArgs(args);
        System.setProperty("fml.ignoreInvalidMinecraftCertificates", "true");
        args = this.getArgs();
        this.argMap = null;
        this.extras = null;
        System.gc();
        Class.forName("net.minecraft.launchwrapper.Launch").getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
    }

    private String[] getArgs() {
        ArrayList<String> list = new ArrayList<String>(22);
        for (Map.Entry<String, String> e : this.argMap.entrySet()) {
            String val = e.getValue();
            if (Strings.isNullOrEmpty((String)val)) continue;
            list.add("--" + e.getKey());
            list.add(val);
        }
        if (!Strings.isNullOrEmpty((String)"net.minecraftforge.fml.common.launcher.FMLServerTweaker")) {
            list.add("--tweakClass");
            list.add("net.minecraftforge.fml.common.launcher.FMLServerTweaker");
        }
        if (this.extras != null) {
            list.addAll(this.extras);
        }
        String[] out = list.toArray(new String[list.size()]);
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int x = 0; x < out.length; ++x) {
            b.append(out[x]);
            if ("--accessToken".equalsIgnoreCase(out[x])) {
                b.append("{REDACTED}");
                ++x;
            }
            if (x >= out.length - 1) continue;
            b.append(", ");
        }
        b.append(']');
        LOGGER.info("Running with arguments: " + b.toString());
        return out;
    }

    private void parseArgs(String[] args) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        for (String key : this.argMap.keySet()) {
            parser.accepts(key).withRequiredArg().ofType(String.class);
        }
        NonOptionArgumentSpec nonOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        for (String key : this.argMap.keySet()) {
            if (!options.hasArgument(key)) continue;
            String value = (String)options.valueOf(key);
            this.argMap.put(key, value);
            if ("password".equalsIgnoreCase(key) || "accessToken".equalsIgnoreCase(key)) continue;
            LOGGER.info(key + ": " + value);
        }
        this.extras = Lists.newArrayList((Iterable)nonOption.values(options));
        LOGGER.info("Extra: " + this.extras);
    }
}

