/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class CatServerConfig {
    private final File configFile;
    private YamlConfiguration config;
    public boolean hopperAsync = false;
    public boolean entityMoveAsync = true;
    public boolean modMobAsync = false;
    public int entityPoolNum = 3;
    public boolean keepSpawnInMemory = true;
    public boolean enableSkipEntityTick = true;
    public boolean enableSkipTileEntityTick = false;
    public boolean enableCapture = true;
    public long worldGenMaxTickTime = 15000000L;
    public List<String> fakePlayerPermissions = Arrays.asList("essentials.build");
    public boolean fakePlayerEventPass = false;
    public boolean disableUpdateGameProfile = true;
    public boolean disableFMLHandshake = false;

    public CatServerConfig(String file) {
        this.configFile = new File(file);
    }

    public void loadConfig() {
        this.config = YamlConfiguration.loadConfiguration(this.configFile);
        this.hopperAsync = this.getOrWriteBooleanConfig("async.hopper", this.hopperAsync);
        this.entityMoveAsync = this.getOrWriteBooleanConfig("async.entityMove", this.entityMoveAsync);
        this.modMobAsync = this.getOrWriteBooleanConfig("async.modMob", this.modMobAsync);
        this.entityPoolNum = this.getOrWriteIntConfig("async.asyncPoolNum", this.entityPoolNum);
        this.keepSpawnInMemory = this.getOrWriteBooleanConfig("world.keepSpawnInMemory", this.keepSpawnInMemory);
        this.enableSkipEntityTick = this.getOrWriteBooleanConfig("world.enableSkipEntityTick", this.enableSkipEntityTick);
        this.enableSkipTileEntityTick = this.getOrWriteBooleanConfig("world.enableSkipTileEntityTick", this.enableSkipTileEntityTick);
        this.enableCapture = this.getOrWriteBooleanConfig("world.enableCapture", this.enableCapture);
        this.worldGenMaxTickTime = this.getOrWriteIntConfig("world.worldGenMaxTick", 15) * 1000000;
        this.fakePlayerPermissions = this.getOrWriteStringListConfig("fakePlayer.permissions", this.fakePlayerPermissions);
        this.fakePlayerEventPass = this.getOrWriteBooleanConfig("fakePlayer.eventPass", this.fakePlayerEventPass);
        this.disableUpdateGameProfile = this.getOrWriteBooleanConfig("disableUpdateGameProfile", this.disableUpdateGameProfile);
        this.disableFMLHandshake = this.getOrWriteBooleanConfig("disableFMLHandshake", this.disableFMLHandshake);
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean getOrWriteBooleanConfig(String path, boolean def) {
        if (this.config.contains(path)) {
            return this.config.getBoolean(path);
        }
        this.config.set(path, def);
        return def;
    }

    private int getOrWriteIntConfig(String path, int def) {
        if (this.config.contains(path)) {
            return this.config.getInt(path);
        }
        this.config.set(path, def);
        return def;
    }

    private List<String> getOrWriteStringListConfig(String path, List<String> def) {
        if (this.config.contains(path)) {
            return this.config.getStringList(path);
        }
        this.config.set(path, def);
        return def;
    }
}

