/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import catserver.server.utils.LanguageUtils;
import catserver.server.utils.Md5Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LibrariesManager {
    private static List<String> librariesSources = new ArrayList<String>();

    public static void checkLibraries() {
        InputStream listStream;
        File libDir = new File("libraries");
        if (!libDir.exists()) {
            libDir.mkdir();
        }
        if ((listStream = ClassLoader.getSystemResourceAsStream("libraries.info")) == null) {
            return;
        }
        boolean hasException = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(listStream));
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                String[] args = str.split("\\|");
                if (args.length != 3) continue;
                try {
                    LibrariesManager.checkAndDownloadLibrary(args[0], args[1], args[2]);
                }
                catch (IOException e2) {
                    System.out.println(e2.toString());
                    hasException = true;
                }
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            System.out.println(e.toString());
            hasException = true;
        }
        if (hasException) {
            System.out.println(LanguageUtils.I18nToString("launch.lib_exception"));
        }
    }

    private static void checkAndDownloadLibrary(String type, String key, String value) throws IOException {
        switch (type) {
            case "source": {
                librariesSources.add(key);
                break;
            }
            case "lib": {
                File file = new File(key);
                if (file.exists() && Md5Utils.getFileMD5String(file).equals(value)) break;
                LibrariesManager.tryDownload(file, value);
                break;
            }
        }
    }

    private static boolean tryDownload(File file, String md5) {
        Iterator<String> iterator = librariesSources.iterator();
        while (iterator.hasNext()) {
            String downloadUrl = iterator.next() + file.getName();
            try {
                new Downloader(downloadUrl, file);
                if (!file.exists() || md5 != null && !Md5Utils.getFileMD5String(file).equals(md5)) {
                    System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_failure_check"), file.getName(), downloadUrl));
                    continue;
                }
                return true;
            }
            catch (IOException e) {
                System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_failure_download"), e.toString(), downloadUrl));
                if (!(e instanceof ConnectException) && !(e instanceof SocketTimeoutException)) continue;
                iterator.remove();
            }
        }
        return false;
    }

    static class Downloader {
        public Downloader(String downloadUrl, File saveFile) throws IOException {
            URL url = new URL(downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(8000);
            connection.setRequestMethod("GET");
            System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_downloading"), saveFile.getName(), this.getSize(connection.getContentLengthLong())));
            ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
            FileOutputStream fos = new FileOutputStream(saveFile);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            rbc.close();
            fos.close();
            connection.disconnect();
        }

        private String getSize(long size) {
            if (size >= 0x100000L) {
                return (float)size / 1048576.0f + " MB";
            }
            if (size >= 1024L) {
                return (float)size / 1024.0f + " KB";
            }
            return size + " B";
        }
    }
}

