/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidUtil {
    private FluidUtil() {
    }

    public static boolean interactWithFluidHandler(@Nonnull aed player, @Nonnull ub hand, @Nonnull amu world, @Nonnull et pos, @Nullable fa side) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)pos);
        IFluidHandler blockFluidHandler = FluidUtil.getFluidHandler(world, pos, side);
        return blockFluidHandler != null && FluidUtil.interactWithFluidHandler(player, hand, blockFluidHandler);
    }

    public static boolean interactWithFluidHandler(@Nonnull aed player, @Nonnull ub hand, @Nonnull IFluidHandler handler) {
        IItemHandler playerInventory;
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        aip heldItem = player.b(hand);
        if (!heldItem.b() && (playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            if (!fluidActionResult.isSuccess()) {
                fluidActionResult = FluidUtil.tryEmptyContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            }
            if (fluidActionResult.isSuccess()) {
                player.a(hand, fluidActionResult.getResult());
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static FluidActionResult tryFillContainer(@Nonnull aip container, IFluidHandler fluidSource, int maxAmount, @Nullable aed player, boolean doFill) {
        FluidStack simulatedTransfer;
        aip containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, false)) != null) {
            if (doFill) {
                FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, true);
                if (player != null) {
                    qe soundevent = simulatedTransfer.getFluid().getFillSound(simulatedTransfer);
                    player.l.a(null, player.p, player.q + 0.5, player.r, soundevent, qg.e, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, true);
            }
            aip resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull aip container, IFluidHandler fluidDestination, int maxAmount, @Nullable aed player, boolean doDrain) {
        aip containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null) {
            if (doDrain) {
                FluidStack transfer = FluidUtil.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, true);
                if (transfer != null) {
                    if (player != null) {
                        qe soundevent = transfer.getFluid().getEmptySound(transfer);
                        player.l.a(null, player.p, player.q + 0.5, player.r, soundevent, qg.e, 1.0f, 1.0f);
                    }
                    aip resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            } else {
                FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, false);
                if (simulatedTransfer != null) {
                    containerFluidHandler.drain(simulatedTransfer, true);
                    aip resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Deprecated
    @Nonnull
    public static FluidActionResult tryFillContainerAndStow(@Nonnull aip container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable aed player) {
        return FluidUtil.tryFillContainerAndStow(container, fluidSource, inventory, maxAmount, player, true);
    }

    @Nonnull
    public static FluidActionResult tryFillContainerAndStow(@Nonnull aip container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable aed player, boolean doFill) {
        if (container.b()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.bO.d) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.E() == 1) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            aip remainder;
            FluidActionResult filledSimulated = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, filledSimulated.getResult(), true)).b() || player != null)) {
                FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, filledReal.getResult(), !doFill);
                if (!remainder.b() && player != null && doFill) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                aip containerCopy = container.l();
                containerCopy.g(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Deprecated
    @Nonnull
    public static FluidActionResult tryEmptyContainerAndStow(@Nonnull aip container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable aed player) {
        return FluidUtil.tryEmptyContainerAndStow(container, fluidDestination, inventory, maxAmount, player, true);
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainerAndStow(@Nonnull aip container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable aed player, boolean doDrain) {
        if (container.b()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.bO.d) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.E() == 1) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            aip remainder;
            FluidActionResult emptiedSimulated = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedSimulated.getResult(), true)).b() || player != null)) {
                FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedReal.getResult(), !doDrain);
                if (!remainder.b() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                aip containerCopy = container.l();
                containerCopy.g(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nullable
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, false);
        if (drainable != null && drainable.amount > 0) {
            return FluidUtil.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return null;
    }

    @Nullable
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack resource, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(resource, false);
        if (drainable != null && drainable.amount > 0 && resource.isFluidEqual(drainable)) {
            return FluidUtil.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return null;
    }

    @Nullable
    private static FluidStack tryFluidTransfer_Internal(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack drainable, boolean doTransfer) {
        int fillableAmount = fluidDestination.fill(drainable, false);
        if (fillableAmount > 0) {
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(fillableAmount, true);
                if (drained != null) {
                    drained.amount = fluidDestination.fill(drained, true);
                    return drained;
                }
            } else {
                drainable.amount = fillableAmount;
                return drainable;
            }
        }
        return null;
    }

    @Nullable
    public static IFluidHandlerItem getFluidHandler(@Nonnull aip itemStack) {
        if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidContained(@Nonnull aip container) {
        IFluidHandlerItem fluidHandler;
        if (!container.b() && (fluidHandler = FluidUtil.getFluidHandler(container = ItemHandlerHelper.copyStackWithSize(container, 1))) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(amu world, et blockPos, @Nullable fa side) {
        avj tileEntity;
        awt state = world.o(blockPos);
        aow block = state.u();
        if (block.hasTileEntity(state) && (tileEntity = world.r(blockPos)) != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        }
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, blockPos);
        }
        if (block instanceof aru) {
            return new BlockLiquidWrapper((aru)block, world, blockPos);
        }
        return null;
    }

    @Nonnull
    public static FluidActionResult tryPickUpFluid(@Nonnull aip emptyContainer, @Nullable aed playerIn, amu worldIn, et pos, fa side) {
        IFluidHandler targetFluidHandler;
        if (emptyContainer.b() || worldIn == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        awt state = worldIn.o(pos);
        aow block = state.u();
        if ((block instanceof IFluidBlock || block instanceof aru) && (targetFluidHandler = FluidUtil.getFluidHandler(worldIn, pos, side)) != null) {
            return FluidUtil.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryPlaceFluid(@Nullable aed player, amu world, et pos, @Nonnull aip container, FluidStack resource) {
        aip containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null && FluidUtil.tryPlaceFluid(player, world, pos, containerFluidHandler, resource)) {
            return new FluidActionResult(containerFluidHandler.getContainer());
        }
        return FluidActionResult.FAILURE;
    }

    public static boolean tryPlaceFluid(@Nullable aed player, amu world, et pos, IFluidHandler fluidSource, FluidStack resource) {
        if (world == null || resource == null || pos == null) {
            return false;
        }
        Fluid fluid = resource.getFluid();
        if (fluid == null || !fluid.canBePlacedInWorld()) {
            return false;
        }
        if (fluidSource.drain(resource, false) == null) {
            return false;
        }
        awt destBlockState = world.o(pos);
        bcz destMaterial = destBlockState.a();
        boolean isDestNonSolid = !destMaterial.a();
        boolean isDestReplaceable = destBlockState.u().a((amy)world, pos);
        if (!(world.d(pos) || isDestNonSolid || isDestReplaceable)) {
            return false;
        }
        if (world.s.l() && fluid.doesVaporize(resource)) {
            FluidStack result = fluidSource.drain(resource, true);
            if (result != null) {
                result.getFluid().vaporize(player, world, pos, result);
                return true;
            }
        } else {
            IFluidHandler handler = FluidUtil.getFluidBlockHandler(fluid, world, pos);
            FluidStack result = FluidUtil.tryFluidTransfer(handler, fluidSource, resource, true);
            if (result != null) {
                qe soundevent = resource.getFluid().getEmptySound(resource);
                world.a(player, pos, soundevent, qg.e, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    private static IFluidHandler getFluidBlockHandler(Fluid fluid, amu world, et pos) {
        aow block = fluid.getBlock();
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, pos);
        }
        if (block instanceof aru) {
            return new BlockLiquidWrapper((aru)block, world, pos);
        }
        return new BlockWrapper(block, world, pos);
    }

    public static void destroyBlockOnFluidPlacement(amu world, et pos) {
        if (!world.G) {
            awt destBlockState = world.o(pos);
            bcz destMaterial = destBlockState.a();
            boolean isDestNonSolid = !destMaterial.a();
            boolean isDestReplaceable = destBlockState.u().a((amy)world, pos);
            if ((isDestNonSolid || isDestReplaceable) && !destMaterial.d()) {
                world.b(pos, true);
            }
        }
    }

    @Nonnull
    public static aip getFilledBucket(@Nonnull FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluidStack.tag == null || fluidStack.tag.b_()) {
            if (fluid == FluidRegistry.WATER) {
                return new aip(air.aA);
            }
            if (fluid == FluidRegistry.LAVA) {
                return new aip(air.aB);
            }
            if (fluid.getName().equals("milk")) {
                return new aip(air.aO);
            }
        }
        if (FluidRegistry.isUniversalBucketEnabled() && FluidRegistry.hasBucket(fluid)) {
            UniversalBucket bucket = ForgeModContainer.getInstance().universalBucket;
            aip filledBucket = new aip((ain)bucket);
            FluidStack fluidContents = new FluidStack(fluidStack, bucket.getCapacity());
            fy tag = new fy();
            fluidContents.writeToNBT(tag);
            filledBucket.b(tag);
            return filledBucket;
        }
        return aip.a;
    }
}

