/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.console.log4j;

import com.google.common.base.Functions;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.function.Function;
import javax.annotation.Nullable;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.fusesource.jansi.AnsiConsole;

@Plugin(name="TerminalConsole", category="Core", elementType="appender", printObject=true)
public class TerminalConsoleAppender
extends AbstractAppender {
    private static final boolean ENABLE_JLINE = PropertiesUtil.getProperties().getBooleanProperty("jline.enable", true);
    private static final PrintStream out = System.out;
    private static boolean initialized;
    private static ConsoleReader reader;
    private static Function<String, String> formatter;

    public static ConsoleReader getReader() {
        return reader;
    }

    public static void setFormatter(Function<String, String> format) {
        formatter = format != null ? format : Functions.identity();
    }

    protected TerminalConsoleAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    @PluginFactory
    @Nullable
    public static TerminalConsoleAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filters") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) String ignore) {
        if (name == null) {
            LOGGER.error("No name provided for TerminalConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.newBuilder().build();
        }
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        System.setProperty("log4j.skipJansi", "true");
        return new TerminalConsoleAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }

    public void start() {
        if (!initialized && reader == null) {
            initialized = true;
            if (ENABLE_JLINE) {
                boolean hasConsole;
                boolean bl2 = hasConsole = System.console() != null;
                if (hasConsole) {
                    try {
                        AnsiConsole.systemInstall();
                        reader = new ConsoleReader();
                        reader.setExpandEvents(false);
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Failed to initialize terminal. Falling back to default.", (Throwable)e2);
                    }
                }
                if (reader == null) {
                    if (hasConsole || System.getProperty("java.class.path").contains("idea_rt.jar")) {
                        TerminalFactory.configure((String)"off");
                        TerminalFactory.reset();
                        try {
                            reader = new ConsoleReader();
                            reader.setExpandEvents(false);
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Failed to initialize fallback terminal. Falling back to standard output console.", (Throwable)e3);
                        }
                    } else {
                        LOGGER.warn("Disabling terminal, you're running in an unsupported environment.");
                    }
                }
            }
        }
        super.start();
    }

    public void append(LogEvent event) {
        if (reader != null) {
            try {
                Writer out = reader.getOutput();
                out.write(13);
                out.write(this.formatEvent(event));
                reader.drawLine();
                reader.flush();
            }
            catch (IOException iOException) {}
        } else {
            out.print(this.formatEvent(event));
        }
    }

    protected String formatEvent(LogEvent event) {
        return formatter.apply(this.getLayout().toSerializable(event).toString());
    }

    static {
        formatter = Functions.identity();
    }
}

