/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import catserver.server.CatServer;
import catserver.server.remapper.CatServerRemapper;
import catserver.server.remapper.ClassInheritanceProvider;
import catserver.server.remapper.MappingLoader;
import catserver.server.remapper.ReflectionTransformer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

final class PluginClassLoader
extends URLClassLoader {
    private final JavaPluginLoader loader;
    private final Map<String, Class<?>> classes = new HashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    final JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private LaunchClassLoader launchClassLoader;
    private CatServerRemapper remapper;
    private JarMapping jarMapping;

    PluginClassLoader(JavaPluginLoader loader, ClassLoader parent, PluginDescriptionFile description, File dataFolder, File file) throws IOException, InvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Validate.notNull((Object)loader, (String)"Loader cannot be null");
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        this.launchClassLoader = parent instanceof LaunchClassLoader ? (LaunchClassLoader)parent : (LaunchClassLoader)MinecraftServer.getServerInst().getClass().getClassLoader();
        this.jarMapping = MappingLoader.loadMapping();
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        provider.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        this.jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        this.remapper = new CatServerRemapper(this.jarMapping);
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex2) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex2);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex3) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", ex3);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex4) {
            throw new InvalidPluginException("No public constructor", ex4);
        }
        catch (InstantiationException ex5) {
            throw new InvalidPluginException("Abnormal plugin type", ex5);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (this.remapper.isNeedRemap(name)) {
            String remappedClass = (String)this.jarMapping.classes.get(name.replaceAll("\\.", "\\/"));
            return this.launchClassLoader.findClass(remappedClass);
        }
        if (name.startsWith("org.bukkit.")) {
            throw new ClassNotFoundException(name);
        }
        Class<?> result = this.classes.get(name);
        String string = name.intern();
        synchronized (string) {
            if (result == null) {
                if (checkGlobal) {
                    result = this.loader.getClassByName(name);
                }
                if (result == null && (result = this.remappedFindClass(name)) != null) {
                    this.loader.setClass(name, result);
                }
                if (result == null) {
                    try {
                        result = this.launchClassLoader.getClass().getClassLoader().loadClass(name);
                    }
                    catch (Throwable throwable) {
                        throw new ClassNotFoundException(name, throwable);
                    }
                }
                if (result == null) {
                    throw new ClassNotFoundException(name);
                }
                this.classes.put(name, result);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    Set<String> getClasses() {
        return this.classes.keySet();
    }

    synchronized void initialize(JavaPlugin javaPlugin) {
        Validate.notNull((Object)javaPlugin, (String)"Initializing plugin cannot be null");
        Validate.isTrue((javaPlugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (String)"Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }

    private Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            InputStream stream;
            String path = name.replace('.', '/').concat(".class");
            URL url = this.findResource(path);
            if (url != null && (stream = url.openStream()) != null) {
                JarURLConnection jarURLConnection;
                URL jarURL;
                CodeSource codeSource;
                byte[] bytecode = null;
                bytecode = this.remapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                result = this.defineClass(name, bytecode = ReflectionTransformer.transform(bytecode), 0, bytecode.length, codeSource = new CodeSource(jarURL = (jarURLConnection = (JarURLConnection)url.openConnection()).getJarFileURL(), new CodeSigner[0]));
                if (result != null) {
                    this.resolveClass(result);
                }
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Failed to remap class " + name, t);
        }
        return result;
    }

    @Override
    protected Package getPackage(String name) {
        if ("org.bukkit.craftbukkit".equals(name)) {
            name = "org.bukkit.craftbukkit." + CatServer.getNativeVersion();
        }
        return super.getPackage(name);
    }
}

