<?php  
// check.php - 支付宝订单到账检测接口 + 自动通知平台  
ini_set('error_log', __DIR__ . '/my_php_error.log');  
header('Content-Type: application/json');  

// === 配置 ===  
$APP_ID = get_config("APP_ID");;  
$PRIVATE_KEY = file_get_contents(__DIR__ . '/RSA2048.pem');  
$MERCHANT_KEY = get_config("MERCHANT_KEY");

function get_config($key = null) {
    static $config = null;
    if ($config === null) {
        $json = file_get_contents(__DIR__ . '/config.json'); // 确保路径正确
        $config = json_decode($json, true);
    }
    if ($key === null) {
        return $config;
    }
    return $config[$key] ?? null;
}
 function log_error($msg) {  
     $log_prefix = '[' . date('Y-m-d H:i:s') . '] ';  
     error_log($log_prefix . $msg);  
 }  


// === 获取请求参数 ===  
$input = json_decode(file_get_contents('php://input'), true);  
$order_id = $input['out_trade_no'] ?? '';  
$moneyRaw = $input['money'] ?? '0';  // 原始金额字符串（如："0.1"）
$moneyForCheck = number_format(floatval($moneyRaw), 2, '.', '');  // 用于查账匹配  
$timestamp = $input['timestamp'] ?? '';  
$pid = $input['pid'] ?? '';  
$type = $input['type'] ?? '';  
$return_url = $input['return_url'] ?? '';  
$notify_url = $input['notify_url'] ?? ''; 
if (!$order_id || !$moneyRaw || !$timestamp) {  
    echo json_encode(["status" => "error", "msg" => "参数缺失"]);  
    exit;  
}

// === 查询时间范围（前后各 90 秒）===  
$base_time  = strtotime($timestamp);  
$start_time = date('Y-m-d H:i:s', $base_time - 90);  
$end_time   = date('Y-m-d H:i:s', $base_time + 90);  

// === 构建请求参数 ===  
$params = [  
    "app_id"     => $APP_ID,  
    "method"     => "alipay.data.bill.accountlog.query",  
    "format"     => "JSON",  
    "charset"    => "utf-8",  
    "sign_type"  => "RSA2",  
    "timestamp"  => date('Y-m-d H:i:s'),  
    "version"    => "1.0",  
    "biz_content" => json_encode([  
        "account_type" => "basic",  
        "start_time"   => $start_time,  
        "end_time"     => $end_time,  
        "page_no"      => 1,  
        "page_size"    => 20  
    ], JSON_UNESCAPED_UNICODE)  
];  

// === 生成签名 ===  
function generateSign($params, $private_key) {  
    ksort($params);  
    $unsigned = urldecode(http_build_query($params));  
    $key = openssl_pkey_get_private($private_key);  
    openssl_sign($unsigned, $sign, $key, OPENSSL_ALGO_SHA256);  
    return base64_encode($sign);  
}  

$params['sign'] = generateSign($params, $PRIVATE_KEY);  

// === 发送请求到支付宝接口 ===  
$ch = curl_init('https://openapi.alipay.com/gateway.do');  
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));  
$response = curl_exec($ch);  
curl_close($ch);  

// === 防乱码处理 ===  
if (!mb_check_encoding($response, 'UTF-8')) {  
    $response = mb_convert_encoding($response, 'UTF-8', 'GBK');  
}  
$response = trim(preg_replace('/^\xEF\xBB\xBF/', '', $response));  

// === 解析 JSON ===  
$json = json_decode($response, true);  
$data = $json['alipay_data_bill_accountlog_query_response'] ?? null;  
if (!$data || ($data['code'] ?? '') !== '10000') {  
    // log_error("支付宝接口调用失败，code: " . ($data['code'] ?? 'null'));  
    echo json_encode(["status" => "error", "msg" => "支付宝接口调用失败"]);  
    exit;  
}  

// === 查找到账记录 ===  
// === 查找到账记录 ===  
$logs = $data['detail_list'] ?? [];  
foreach ($logs as $item) {  
    $direction = trim($item['direction'] ?? '');  
    $memo      = $item['trans_memo'] ?? '';  
    $amount    = number_format(floatval($item['trans_amount'] ?? 0), 2, '.', '');  

    $is_income = ($direction === '收入' || strpos($direction, '收') !== false);  
    if ($is_income && $memo === $order_id && floatval($amount) == floatval($moneyForCheck)) {  

        // === 构造回调数据（签名用原始金额）===  
// === 构造回调数据 ===
// 从原始请求中复制字段
// === 使用输入数据构造基础数据 ===
    $callbackData = $input;
    
    // 移除不参与签名的字段
    unset($callbackData['sign'], $callbackData['sign_type'], $callbackData['timestamp']);
    
    // 添加平台要求字段（但注意：添加在签名前！）
    $callbackData['trade_status'] = "TRADE_SUCCESS";
    
    // === 生成签名用的数组副本 ===
    $signData = $callbackData;
    ksort($signData);
    
    // 构造签名字符串
    $signStr = '';
    foreach ($signData as $k => $v) {
        $signStr .= $k . '=' . $v . '&';
    }
    $signStr = rtrim($signStr, '&');
    
    // 生成签名
    $sign = md5($signStr . $MERCHANT_KEY);
    
    // 将签名加入回原始数据中
    $callbackData['sign'] = $sign;
    $callbackData['sign_type'] = 'MD5';
    
    // === 日志（调试用）===
    log_error("调试签名字符串: $signStr");
    log_error("计算签名: $sign");
    log_error("使用密钥: $MERCHANT_KEY");
    
    // $callbackData 现在可以安全发送给平台

        // === 通知平台 ===  
        if ($notify_url) {  
            $ch = curl_init($notify_url);  
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  
            curl_setopt($ch, CURLOPT_POST, true);  
            $postData = http_build_query($callbackData);
            // log_error("准备回调给平台的POST数据: $postData");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
            $notify_response = curl_exec($ch);  
            curl_close($ch);  

            log_error("已回调通知平台: $notify_url 响应: $notify_response");  
        }  

        echo json_encode([  
            "status" => "success",  
            "msg" => "支付成功",  
            "matched_record" => $item  
        ]);  
        exit;  
    }  
}

echo json_encode([  
    "status" => "pending",  
    "msg" => "尚未支付"  
]);