/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.aes;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.render.point.UpdatableShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0006J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsUtil;", "", "()V", "ALPHA_CONTROLS_BOTH", "", "alpha", "", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "decorate", "", "shape", "Lorg/jetbrains/letsPlot/core/plot/base/render/point/UpdatableShape;", "filled", "solid", "strokeWidth", "fill", "pointStrokeWidth", "textSize", "updateFill", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgShape;", "updateStroke", "applyAlpha", "plot-base"})
public final class AestheticsUtil {
    @NotNull
    public static final AestheticsUtil INSTANCE = new AestheticsUtil();
    public static final boolean ALPHA_CONTROLS_BOTH = false;

    private AestheticsUtil() {
    }

    @NotNull
    public final Color fill(boolean filled, boolean solid, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (filled) {
            Color color = p.fill();
            Intrinsics.checkNotNull((Object)color);
            return color;
        }
        if (solid) {
            Color color = p.color();
            Intrinsics.checkNotNull((Object)color);
            return color;
        }
        return Color.Companion.getTRANSPARENT();
    }

    public final void decorate(@NotNull UpdatableShape shape, boolean filled, boolean solid, @NotNull DataPointAesthetics p, double strokeWidth) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Color fill = this.fill(filled, solid, p);
        Color color = p.color();
        Intrinsics.checkNotNull((Object)color);
        Color stroke = color;
        double fillAlpha = 0.0;
        if (filled || solid) {
            fillAlpha = this.alpha(fill, p);
        }
        double strokeAlpha = 0.0;
        if (strokeWidth > 0.0) {
            strokeAlpha = this.alpha(stroke, p);
        }
        shape.update(fill, fillAlpha, stroke, strokeAlpha, strokeWidth);
    }

    public final double alpha(@NotNull Color color, @NotNull DataPointAesthetics p) {
        double d;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (!Intrinsics.areEqual((Double)p.alpha(), (double)0.999887)) {
            Double d2 = p.alpha();
            Intrinsics.checkNotNull((Object)d2);
            d = d2;
        } else {
            d = SvgUtils.INSTANCE.alpha2opacity(color.getAlpha());
        }
        return d;
    }

    public final double strokeWidth(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return AesScaling.INSTANCE.strokeWidth(p);
    }

    public final double pointStrokeWidth(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return AesScaling.INSTANCE.pointStrokeWidth(p);
    }

    public final double textSize(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return AesScaling.INSTANCE.textSize(p);
    }

    public final void updateStroke(@NotNull SvgShape shape, @NotNull DataPointAesthetics p, boolean applyAlpha) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        shape.strokeColor().set((Object)p.color());
        if (!Intrinsics.areEqual((Double)p.alpha(), (double)0.999887) && applyAlpha) {
            shape.strokeOpacity().set((Object)p.alpha());
        }
    }

    public final void updateFill(@NotNull SvgShape shape, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        shape.fillColor().set((Object)p.fill());
        if (!Intrinsics.areEqual((Double)p.alpha(), (double)0.999887)) {
            shape.fillOpacity().set((Object)p.alpha());
        }
    }
}

